/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client.transformer;

import com.sap.cloud.lm.sl.slp.client.transformer.IObjectTransformer;
import com.sap.cloud.lm.sl.slp.client.transformer.JaxbObjectTransformer;
import com.sap.cloud.lm.sl.slp.client.transformer.JsonObjectTransformer;
import com.sap.cloud.lm.sl.slp.client.transformer.ObjectTransformerException;
import com.sap.cloud.lm.sl.slp.client.transformer.TextPlainObjectTransformer;

public class ObjectTransformerFactory {
    private static final String APPLICATION_XML_REGEX = "(?i)application/xml.*";
    private static final String APPLICATION_JSON_REGEX = "(?i)application/json.*";
    private static final String TEXT_PLAIN_REGEX = "(?i)text/plain.*";

    public static final synchronized IObjectTransformer getProvider(String contentType) throws ObjectTransformerException {
        if (contentType.matches(APPLICATION_XML_REGEX)) {
            return new JaxbObjectTransformer();
        }
        if (contentType.matches(APPLICATION_JSON_REGEX)) {
            return new JsonObjectTransformer();
        }
        if (contentType.matches(TEXT_PLAIN_REGEX)) {
            return new TextPlainObjectTransformer();
        }
        throw new ObjectTransformerException("Not supported content type \"{0}\"", contentType);
    }

    public static boolean canParseTextContent(String contentType) {
        return contentType.matches(TEXT_PLAIN_REGEX);
    }
}

