/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client.urls;

import java.net.MalformedURLException;
import java.net.URL;

public abstract class BaseSlpUrlProvider {
    private String baseUrl;

    BaseSlpUrlProvider(String baseUrl) {
        try {
            this.baseUrl = new URL(baseUrl).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    BaseSlpUrlProvider(String baseUrl, String processRootUrl) {
        try {
            this.baseUrl = new URL(new URL(this.normalizeURL(baseUrl)), processRootUrl).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizeURL(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    protected String getNormalizedUrl(String baseUrl, String suffix) {
        return this.normalizeURL(baseUrl) + suffix;
    }

    String getBaseUrl() {
        return this.baseUrl;
    }
}

