/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.tomcat.session.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;

public class TenantAwareSession
extends StandardSession {
    private static final long serialVersionUID = 1L;
    private String tenantId;

    public TenantAwareSession(Manager manager, String tenantId) {
        super(manager);
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void recycle() {
        super.recycle();
        this.tenantId = null;
    }

    protected void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        super.readObject(stream);
        this.tenantId = (String)stream.readObject();
    }

    protected void writeObject(ObjectOutputStream stream) throws IOException {
        super.writeObject(stream);
        stream.writeObject(this.tenantId);
    }
}

