/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.tomcat.session.management;

import com.sap.cloud.tomcat.session.management.TenantAwareSession;
import com.sap.core.tenant.api.Tenant;
import java.io.IOException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAwareSessionManager
extends StandardManager {
    private static final String PARSE_SESSION_COOKIES_METHOD_NAME = "parseSessionCookiesId";
    private static final String PARSE_SESSION_COOKIES_CLASS_NAME = "org.apache.catalina.connector.CoyoteAdapter";
    private static final Logger LOGGER = LoggerFactory.getLogger(TenantAwareSessionManager.class);
    private static ThreadLocal<Boolean> loggingStartedMarker = new ThreadLocal();

    protected StandardSession getNewSession() {
        TenantAwareSession tenantAwareSession = new TenantAwareSession((Manager)this, this.getTenantId());
        return tenantAwareSession;
    }

    public Session findSession(String id) throws IOException {
        if (id == null) {
            return null;
        }
        Session session = (Session)this.sessions.get(id);
        if (session instanceof TenantAwareSession) {
            TenantAwareSession tenantAwareSession = (TenantAwareSession)session;
            String currentTenantId = this.getTenantId();
            String sessionTenantId = tenantAwareSession.getTenantId();
            if (currentTenantId == null && sessionTenantId == null || currentTenantId != null && sessionTenantId != null && currentTenantId.equals(sessionTenantId) || this.areRequestSessionCookiesCurrentlyParsed().booleanValue()) {
                if (LOGGER.isDebugEnabled()) {
                    this.logDebugSafely("Requested session is found and findSession() will return it. currentTenantId is null [" + (currentTenantId == null) + "]; sessionTenantId is null [" + (sessionTenantId == null) + "].");
                }
                return session;
            }
            if (LOGGER.isDebugEnabled()) {
                this.logDebugSafely("Access to the requested session is denied as the current tenant id and the tenant id of the requested tenant aware session do not match. currentTenantId is null [" + (currentTenantId == null) + "]; sessionTenantId is null [" + (sessionTenantId == null) + "].");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            this.logDebugSafely("Requested session is either not found or access to it is denied. findSession() will return null.");
        }
        return null;
    }

    protected String getTenantId() {
        return Tenant.getId();
    }

    private Boolean areRequestSessionCookiesCurrentlyParsed() {
        StackTraceElement[] callingFrames = new Throwable().getStackTrace();
        int count = 0;
        StackTraceElement[] stackTraceElementArray = callingFrames;
        int n = callingFrames.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement callingFrame = stackTraceElementArray[n2];
            if (count++ > 10) break;
            if (PARSE_SESSION_COOKIES_METHOD_NAME.equals(callingFrame.getMethodName()) && PARSE_SESSION_COOKIES_CLASS_NAME.equals(callingFrame.getClassName())) {
                if (LOGGER.isDebugEnabled()) {
                    this.logDebugSafely("Request session cookies are currently parsed.");
                }
                return true;
            }
            ++n2;
        }
        if (LOGGER.isDebugEnabled()) {
            this.logDebugSafely("Request session cookies are not currently parsed.");
        }
        return false;
    }

    private void logDebugSafely(String message) {
        if (loggingStartedMarker.get() == null) {
            try {
                loggingStartedMarker.set(true);
                LOGGER.debug(message);
            }
            finally {
                loggingStartedMarker.remove();
            }
        }
    }
}

