/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.log.providers.impl;

import com.sap.core.js.logging.LoggingFieldProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFiledProviderImpl
implements LoggingFieldProvider {
    private static final String INIT_CONFIG_FILE = "space.properties";
    private static final Logger logger = LoggerFactory.getLogger(LoggingFiledProviderImpl.class);
    private String[] names = null;
    private String[] values = null;
    private static Properties properties = new Properties();

    public LoggingFiledProviderImpl() {
        this.init();
    }

    private void init() {
        this.setJPLogFields();
        this.names = new String[3];
        this.values = new String[3];
        this.values[0] = properties.getProperty("jpSpace");
        this.names[0] = "JPSpace";
        this.values[1] = properties.getProperty("jpApp");
        this.names[1] = "JPApplication";
        this.values[2] = properties.getProperty("component");
        this.names[2] = "JPApplication";
    }

    public String[] getFieldDescriptions() {
        return new String[]{"Provide jpspace, jpaplicance and jpcomponent log field values."};
    }

    public String[] getFieldNames() {
        return Arrays.copyOf(this.names, this.names.length);
    }

    public String[] getFieldValues(String loggerName) {
        return Arrays.copyOf(this.values, this.values.length);
    }

    private void setJPLogFields() {
        block14: {
            InputStream input = null;
            try {
                try {
                    File config_file = new File(INIT_CONFIG_FILE);
                    input = config_file.exists() ? new FileInputStream(config_file) : this.getClass().getClassLoader().getResourceAsStream(INIT_CONFIG_FILE);
                    properties.load(input);
                }
                catch (IOException e) {
                    logger.error("Cannot read space.properties file", (Throwable)e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

