/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenResponseFilter;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractTokenService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="/token")
public class AccessTokenService
extends AbstractTokenService {
    private List<AccessTokenGrantHandler> grantHandlers = new LinkedList<AccessTokenGrantHandler>();
    private List<AccessTokenResponseFilter> responseHandlers = new LinkedList<AccessTokenResponseFilter>();

    public void setGrantHandlers(List<AccessTokenGrantHandler> handlers) {
        this.grantHandlers = handlers;
    }

    @Override
    protected void injectContextIntoOAuthProviders() {
        super.injectContextIntoOAuthProviders();
        for (AccessTokenGrantHandler grantHandler : this.grantHandlers) {
            OAuthUtils.injectContextIntoOAuthProvider(this.getMessageContext(), grantHandler);
        }
    }

    public void setGrantHandler(AccessTokenGrantHandler handler) {
        this.setGrantHandlers(Collections.singletonList(handler));
    }

    public void setResponseFilters(List<AccessTokenResponseFilter> handlers) {
        this.responseHandlers = handlers;
    }

    public void setResponseFilter(AccessTokenResponseFilter responseHandler) {
        this.responseHandlers.add(responseHandler);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response handleTokenRequest(MultivaluedMap<String, String> params) {
        Client client = this.authenticateClientIfNeeded(params);
        if (!OAuthUtils.isGrantSupportedForClient(client, this.isCanSupportPublicClients(), (String)params.getFirst((Object)"grant_type"))) {
            LOG.log(Level.FINE, "The grant type {} is not supported for the client", params.getFirst((Object)"grant_type"));
            return this.createErrorResponse(params, "unauthorized_client");
        }
        try {
            this.checkAudience(client, params);
        }
        catch (OAuthServiceException ex) {
            return super.createErrorResponseFromBean(ex.getError());
        }
        AccessTokenGrantHandler handler = this.findGrantHandler(params);
        if (handler == null) {
            LOG.fine("No Grant Handler found");
            return this.createErrorResponse(params, "unsupported_grant_type");
        }
        ServerAccessToken serverToken = null;
        try {
            serverToken = handler.createAccessToken(client, params);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            LOG.log(Level.FINE, "Error creating the access token", ex);
            OAuthServiceException oauthEx = ex instanceof OAuthServiceException ? (OAuthServiceException)ex : new OAuthServiceException(ex);
            return this.handleException(oauthEx, "invalid_grant");
        }
        if (serverToken == null) {
            LOG.fine("No access token was created");
            return this.createErrorResponse(params, "invalid_grant");
        }
        ClientAccessToken clientToken = OAuthUtils.toClientAccessToken(serverToken, this.isWriteOptionalParameters());
        this.processClientAccessToken(clientToken, serverToken);
        return Response.ok((Object)clientToken).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").build();
    }

    protected void processClientAccessToken(ClientAccessToken clientToken, ServerAccessToken serverToken) {
        for (AccessTokenResponseFilter filter : this.responseHandlers) {
            filter.process(clientToken, serverToken);
        }
    }

    protected void checkAudience(Client c, MultivaluedMap<String, String> params) {
        String audienceParam = (String)params.getFirst((Object)"audience");
        if (!OAuthUtils.validateAudience(audienceParam, c.getRegisteredAudiences())) {
            LOG.fine("Error validating the audience parameter");
            throw new OAuthServiceException(new OAuthError("access_denied"));
        }
    }

    protected AccessTokenGrantHandler findGrantHandler(MultivaluedMap<String, String> params) {
        String grantType = (String)params.getFirst((Object)"grant_type");
        if (grantType != null) {
            AuthorizationCodeGrantHandler handler;
            for (AccessTokenGrantHandler handler2 : this.grantHandlers) {
                if (!handler2.getSupportedGrantTypes().contains(grantType)) continue;
                return handler2;
            }
            if (super.getDataProvider() instanceof AuthorizationCodeDataProvider && (handler = new AuthorizationCodeGrantHandler()).getSupportedGrantTypes().contains(grantType)) {
                handler.setDataProvider((AuthorizationCodeDataProvider)super.getDataProvider());
                return handler;
            }
        }
        return null;
    }
}

