/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import com.sap.cloud.auditlog.AuditLogMessageFactory;
import com.sap.cloud.auditlog.SecurityEventAuditMessage;
import com.sap.cloud.auditlog.exception.AuditLogWriteException;
import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogUtil.class);
    private static AuditLogMessageFactory auditLogFactory;

    public void bindAuditLogMessageFactory(AuditLogMessageFactory factory) {
        auditLogFactory = factory;
    }

    public void unbindAuditLogMessageFactory(AuditLogMessageFactory factory) {
        auditLogFactory = null;
    }

    public static void auditLogMessage(String errorMessage, Class<?> className) {
        AuditLogUtil.initAuditlogFactoryNonOSGI();
        if (auditLogFactory != null) {
            SecurityEventAuditMessage message = (SecurityEventAuditMessage)auditLogFactory.createAuditLogMessage(SecurityEventAuditMessage.class);
            message.setMessage(errorMessage);
            try {
                message.setTimestamp(System.currentTimeMillis());
                message.log(className);
            }
            catch (AuditLogWriteException e) {
                logger.error("Could not audit log errorMessage: " + errorMessage, (Throwable)e);
            }
        }
    }

    public static void auditLogMessage(String errorMessage, String[] params, Class<?> className) {
        AuditLogUtil.initAuditlogFactoryNonOSGI();
        if (auditLogFactory != null) {
            SecurityEventAuditMessage message = (SecurityEventAuditMessage)auditLogFactory.createAuditLogMessage(SecurityEventAuditMessage.class);
            message.setMessage(errorMessage);
            int i = 0;
            while (i < params.length) {
                message.addCustomAttribute("param" + i, params[i]);
                ++i;
            }
            try {
                message.setTimestamp(System.currentTimeMillis());
                message.log(className);
            }
            catch (AuditLogWriteException e) {
                logger.error("Could not audit log errorMessage: " + message.toString(), (Throwable)e);
            }
        }
    }

    public static void auditLogMessage(String errorMessage, Map<String, String> properties, Class<?> className) {
        AuditLogUtil.initAuditlogFactoryNonOSGI();
        if (auditLogFactory != null) {
            SecurityEventAuditMessage message = (SecurityEventAuditMessage)auditLogFactory.createAuditLogMessage(SecurityEventAuditMessage.class);
            message.setMessage(errorMessage);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                message.addCustomAttribute(entry.getKey(), entry.getValue().toString());
            }
            try {
                message.setTimestamp(System.currentTimeMillis());
                message.log(className);
            }
            catch (AuditLogWriteException e) {
                logger.error("Could not audit log errorMessage: " + message.toString(), (Throwable)e);
            }
        }
    }

    private static void initAuditlogFactoryNonOSGI() {
        if (auditLogFactory == null && RuntimeUtils.isRunningInNonOsgi()) {
            ServiceLoader<AuditLogMessageFactory> loader = ServiceLoader.load(AuditLogMessageFactory.class, ClassloadingBridge.getImplClassLoader());
            Iterator<AuditLogMessageFactory> iterator = loader.iterator();
            if (iterator.hasNext()) {
                auditLogFactory = iterator.next();
            } else {
                logger.error("There was no AuditLogMessageFactory registered.");
            }
        }
    }
}

