/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEntitiesValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEntitiesValidator.class);
    private static final Pattern PATTERN_ALPHANUMERIC_LOWERCASE = Pattern.compile("^[a-z][a-z0-9]{0,29}$");
    private static final Pattern PATTERN_TENANT_NAME = Pattern.compile("(([a-z0-9])|([a-z0-9])([-a-z0-9])*([a-z0-9]))");

    public static boolean isValidTenantString(String tenantName) {
        LOGGER.debug("Checking tenant name: '{}'", (Object)tenantName);
        return CloudEntitiesValidator.checkName(PATTERN_TENANT_NAME, tenantName);
    }

    public static boolean isValidApplicationName(String applicationName) {
        LOGGER.debug("Checking applicationName name: '{}'", (Object)applicationName);
        return CloudEntitiesValidator.checkName(PATTERN_ALPHANUMERIC_LOWERCASE, applicationName);
    }

    public static boolean isInvalidApplicationName(String applicationName) {
        return !CloudEntitiesValidator.isValidApplicationName(applicationName);
    }

    public static boolean isValidAccountName(String accountName) {
        LOGGER.debug("Checking account name: '{}'", (Object)accountName);
        return CloudEntitiesValidator.checkName(PATTERN_ALPHANUMERIC_LOWERCASE, accountName);
    }

    public static boolean isInvalidAccountName(String accountName) {
        return !CloudEntitiesValidator.isValidAccountName(accountName);
    }

    public static boolean isValidTokenString(String token) {
        LOGGER.debug("Checking token name: '{}'", (Object)token);
        return CloudEntitiesValidator.checkName(PATTERN_TENANT_NAME, token);
    }

    public static boolean isInvalidTokenString(String token) {
        return !CloudEntitiesValidator.isValidTokenString(token);
    }

    private static boolean checkName(Pattern pattern, String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (pattern.matcher(name).matches()) {
            LOGGER.debug("Name '{}' is valid", (Object)name);
            return true;
        }
        LOGGER.debug("Name '{}' contains invalid characters against pattern '{}'", (Object)name, (Object)pattern);
        return false;
    }
}

