/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class ConnectionBuilder {
    static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    static final String APPLICATION_JSON = "application/json";
    static final String HTTP_HEADER_ACCEPT = "Accept";
    private URL requestUrl;
    static final String HTTP_METHOD_GET = "GET";
    private String httpMethod = "GET";

    public ConnectionBuilder requestUrl(URL requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    public ConnectionBuilder httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpURLConnection createConnection() throws IOException, ProtocolException {
        if (this.requestUrl == null) {
            throw new IllegalArgumentException("Request URL is not specified.");
        }
        HttpURLConnection connection = (HttpURLConnection)this.requestUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(30000);
        connection.setRequestMethod(this.httpMethod);
        connection.setRequestProperty(HTTP_HEADER_ACCEPT, APPLICATION_JSON);
        return connection;
    }
}

