/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    /*
     * Loose catch block
     */
    public static String readFile(File file) {
        String string;
        BufferedReader reader;
        block17: {
            String line;
            if (file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("File for parsing is null!");
                }
                return "";
            }
            if (!file.exists()) {
                logger.debug("File does not exist!");
                return "";
            }
            reader = null;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            string = builder.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug("Reader cannot be closed");
            }
        }
        return string;
        catch (IOException exc) {
            block19: {
                block18: {
                    try {
                        if (!logger.isDebugEnabled()) break block18;
                        logger.debug("Could not read file! Most probably is not found: " + exc.getMessage());
                    }
                    catch (Throwable throwable) {
                        block20: {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                            catch (IOException iOException) {
                                if (!logger.isDebugEnabled()) break block20;
                                logger.debug("Reader cannot be closed");
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    if (!logger.isDebugEnabled()) break block19;
                    logger.debug("Reader cannot be closed");
                }
            }
            return "";
        }
    }

    public static void writeFile(File file, String contents) {
        block19: {
            if (file == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("File for writing is null!");
                }
                return;
            }
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.error("Could not create file " + e.getMessage());
                    return;
                }
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    writer.write(contents);
                }
                catch (IOException iOException) {
                    logger.error("Exception while writing file has occured");
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException iOException2) {
                            logger.debug("Could not close file stream.");
                        }
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {
                        logger.debug("Could not close file stream.");
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    logger.debug("Could not close file stream.");
                }
            }
        }
    }

    public static Properties loadFileProperties(String fileName) {
        Properties sapceProps;
        block14: {
            File file = new File(fileName);
            FileInputStream in = null;
            sapceProps = new Properties();
            try {
                try {
                    in = new FileInputStream(file);
                    sapceProps.load(in);
                }
                catch (IOException e) {
                    logger.error("Problem while loading properties from file: " + fileName, (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            logger.debug("Could not close file stream.");
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        logger.debug("Could not close file stream.");
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    logger.debug("Could not close file stream.");
                }
            }
        }
        return sapceProps;
    }

    public static File getOrCreateJsonFile(String fileName) throws IOException {
        File jsonFile = new File(fileName);
        if (!jsonFile.exists()) {
            logger.info("File [" + jsonFile.getName() + "] doesn't exist at location [" + jsonFile.getAbsolutePath() + "] and will be created.");
            File dir = jsonFile.getAbsoluteFile().getParentFile();
            boolean dirExists = dir.exists();
            if (!dirExists) {
                dirExists = dir.mkdirs();
            }
            boolean fileExists = jsonFile.createNewFile();
            if (!dirExists || !fileExists) {
                String msg = "File [" + jsonFile.getName() + "] cannot be created at location [" + jsonFile.getAbsolutePath() + "].";
                logger.error(msg);
                throw new IOException(msg);
            }
            logger.info("File [" + jsonFile.getName() + "] created at location [" + jsonFile.getAbsolutePath() + "].");
        }
        return jsonFile;
    }
}

