/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import com.sap.core.jpaas.security.utils.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class PasswordHash {
    private char[] _password = null;
    public static final String ALGID_SSHA = "{SSHA}";
    private String passString;

    public PasswordHash(char[] password) {
        this._password = (char[])password.clone();
        this.passString = new String(this._password);
    }

    public String getHash() throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this.passString.contains(ALGID_SSHA)) {
            return this.passString;
        }
        byte[] salt = new byte[6];
        Random random = new Random();
        random.nextBytes(salt);
        String hash = this.createHash01(salt);
        if (hash == null) {
            return null;
        }
        return ALGID_SSHA + hash;
    }

    public boolean checkHash(String Hash) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (Hash == null || Hash.length() == 0) {
            return false;
        }
        String myhash = Hash.substring(ALGID_SSHA.length(), Hash.length());
        byte[] decodedhash = null;
        decodedhash = Base64.decode(myhash);
        byte[] salt = new byte[decodedhash.length - 20];
        System.arraycopy(decodedhash, 20, salt, 0, salt.length);
        return myhash.equals(this.createHash01(salt));
    }

    private String createHash01(byte[] salt) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (this._password == null) {
            return null;
        }
        if (this.passString.contains(ALGID_SSHA)) {
            return this.passString.substring(ALGID_SSHA.length(), this.passString.length());
        }
        byte[] output = null;
        byte[] pass_n_salt = null;
        output = new String(this._password).getBytes("UTF8");
        pass_n_salt = new byte[output.length + salt.length];
        System.arraycopy(output, 0, pass_n_salt, 0, output.length);
        System.arraycopy(salt, 0, pass_n_salt, output.length, salt.length);
        pass_n_salt = this.sha(pass_n_salt);
        byte[] newpass = new byte[pass_n_salt.length + salt.length];
        System.arraycopy(pass_n_salt, 0, newpass, 0, pass_n_salt.length);
        System.arraycopy(salt, 0, newpass, pass_n_salt.length, salt.length);
        return Base64.encode(newpass);
    }

    private byte[] sha(byte[] input) throws NoSuchAlgorithmException {
        byte[] output = null;
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(input);
        output = md.digest();
        return output;
    }
}

