/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyUtils {
    public static String getProperty(Dictionary<String, String> properties, String key, String defaultValue) {
        String value = properties.get(key);
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return value.trim();
    }

    public static Set<String> getPropertyAsSet(Dictionary<String, String> properties, String key, String defaultValue) {
        String valueList = PropertyUtils.getProperty(properties, key, defaultValue).trim();
        return PropertyUtils.getPropertyAsSet(valueList);
    }

    public static Set<String> getPropertyAsSet(String valueList) {
        String[] tokens;
        HashSet<String> propertiesSet = new HashSet<String>();
        if (valueList != null && valueList.trim().length() > 0 && (tokens = valueList.split(";")) != null) {
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                propertiesSet.add(token.trim());
                ++n2;
            }
        }
        return propertiesSet;
    }

    public static List<String> getPropertyAsList(Dictionary<String, String> properties, String key, String defaultValue) {
        String valueList = PropertyUtils.getProperty(properties, key, defaultValue).trim();
        return PropertyUtils.getPropertyAsList(valueList);
    }

    public static List<String> getPropertyAsList(String valueList) {
        if ((valueList = valueList.trim()).length() > 0) {
            return Arrays.asList(valueList.split(";"));
        }
        return new ArrayList<String>();
    }
}

