/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils;

import com.sap.core.jpaas.security.utils.TenantData;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DomainDBConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.core.jpaas.security.utils.gson.GsonParserFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantRetriever {
    private static final Logger logger = LoggerFactory.getLogger(TenantRetriever.class);
    private static final String DEFAULT_TENANT_PATH_TEMPLATE = "rest/accounts/%s/defaultTenant";
    private static final String GET_TENANT_BY_ALIAS = "/rest/tenants/alias/%s";

    public String fetchDefaultTenantNameForAccount(String accountName) throws IOException {
        logger.debug("Retrieving default tenant name for account [{}]", (Object)accountName);
        String path = String.format(DEFAULT_TENANT_PATH_TEMPLATE, accountName);
        return this.fetchTenantDataFromDomainDb(path);
    }

    public String fetchTenantNameByAlias(String tenantAlias) throws IOException {
        logger.debug("Retrieving tenant id for alias [{}]", (Object)tenantAlias);
        String path = String.format(GET_TENANT_BY_ALIAS, tenantAlias);
        return this.fetchTenantDataFromDomainDb(path);
    }

    private String fetchTenantDataFromDomainDb(String path) throws FileNotFoundException, IOException {
        DomainDBConnection dbConnection = this.createDomainDBConnection();
        Request request = (Request)new URLRequest.Builder().withGETMethod().withPath(path).build();
        logger.debug("Executing request [{}]", (Object)request);
        Response response = null;
        try {
            response = dbConnection.execute(request);
            if (response.isOK()) {
                String string = this.parseTenantNameFromResponse(response);
                return string;
            }
            if (response.is(404)) {
                throw new FileNotFoundException("Tenant not found for path [" + path + "] is not found. Server returned: Http Code [" + response.getStatus() + "]");
            }
            throw new IOException("Failed to fetch tenant data from domainDB with path [" + path + "]. Status code was " + response.getStatus());
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    private String parseTenantNameFromResponse(Response response) throws FileNotFoundException {
        String responseBody = response.asString();
        logger.debug("Received tenant response with status code {} and body {}", (Object)response.getStatus(), (Object)responseBody);
        TenantData tenantResponse = GsonParserFactory.getGsonParserInstance().fromJson(responseBody, TenantData.class);
        if (tenantResponse == null) {
            logger.debug("Result could not be parsed to object TenantData.");
            throw new FileNotFoundException(String.format("Tenant not found. Server returned: Http Code [%s], Http Body [%s].", response.getStatus(), responseBody));
        }
        return tenantResponse.getName();
    }

    DomainDBConnection createDomainDBConnection() {
        return new DomainDBConnection();
    }
}

