/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.cache;

import com.sap.core.jpaas.security.utils.cache.TenantCacheConfiguration;
import com.sap.core.jpaas.security.utils.cache.TenantCacheEntry;
import com.sap.core.jpaas.security.utils.cache.TenantCacheEntryComparator;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCache<T>
implements TenantCacheConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(TenantCache.class);
    private static final long INFINITE_CACHE = 0L;
    private TenantCacheValueReader<T> valueReader;
    private long valueTimeout;
    private long lastAccessTimeout;
    private long cacheMaxSize;
    private Map<String, TenantCacheEntry<T>> cacheEntries = new HashMap<String, TenantCacheEntry<T>>();

    public TenantCache(TenantCacheValueReader<T> valueReader, long valueTimeout, long lastAccessTimeout) {
        this(valueReader, valueTimeout, lastAccessTimeout, 0L);
    }

    public TenantCache(TenantCacheValueReader<T> valueReader, long valueTimeout, long lastAccessTimeout, long cacheMaxSize) {
        this.valueReader = valueReader;
        this.valueTimeout = valueTimeout;
        this.lastAccessTimeout = lastAccessTimeout;
        this.cacheMaxSize = cacheMaxSize;
        logger.debug("Tenant cache was created with reader of type: [{}] and with value timeout: [{}] and with last access timeout: [{}] and with cache size limit: [{}]", new Object[]{valueReader.getClass(), valueTimeout, lastAccessTimeout, cacheMaxSize});
    }

    @Override
    public long getValueTimeout() {
        return this.valueTimeout;
    }

    public void setValueTimeout(long valueTimeout) {
        this.valueTimeout = valueTimeout;
    }

    @Override
    public long getLastAccessTimeout() {
        return this.lastAccessTimeout;
    }

    public void setLastAccessTimeout(long lastAccessTimeout) {
        this.lastAccessTimeout = lastAccessTimeout;
    }

    public synchronized TenantCacheEntry<T> getTenantCacheEntry(String tenantId) {
        TenantCacheEntry<T> entry = this.getTenantCacheEntryFromCache(tenantId);
        if (this.cacheMaxSize != 0L && this.cacheMaxSize < (long)this.getSize()) {
            this.clearCache(tenantId, (long)this.getSize() - this.cacheMaxSize);
        }
        return entry;
    }

    public void clearCache(String entryTenant, long entriesToRemoveCount) {
        Map<String, TenantCacheEntry<T>> cache = this.getCacheEntries();
        TenantCacheEntryComparator<T> comparator = new TenantCacheEntryComparator<T>(cache);
        TreeMap<String, TenantCacheEntry<T>> sortedCache = new TreeMap<String, TenantCacheEntry<T>>(comparator);
        sortedCache.putAll(cache);
        int removedCount = 0;
        while ((long)removedCount < entriesToRemoveCount) {
            String leastRecentlyUsedTenantCacheEntry = sortedCache.pollLastEntry().getKey();
            if (leastRecentlyUsedTenantCacheEntry.equals(entryTenant)) continue;
            cache.remove(leastRecentlyUsedTenantCacheEntry);
            ++removedCount;
        }
    }

    public int getSize() {
        return this.getCacheEntries().size();
    }

    private TenantCacheEntry<T> getTenantCacheEntryFromCache(String tenantId) {
        TenantCacheEntry<T> entry = this.cacheEntries.get(tenantId);
        if (entry == null) {
            entry = new TenantCacheEntry<T>(this, tenantId, this.valueReader);
            this.cacheEntries.put(tenantId, entry);
        }
        return entry;
    }

    private Map<String, TenantCacheEntry<T>> getCacheEntries() {
        return this.cacheEntries;
    }
}

