/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.cache;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.core.jpaas.security.utils.cache.TenantCacheConfiguration;
import com.sap.core.jpaas.security.utils.cache.TenantCacheValueReader;
import com.sap.core.tenant.api.Tenant;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantCacheEntry<T>
implements Runnable {
    private static final String CACHE_UPDATERS = "Cache updaters";
    private static final Logger LOG = LoggerFactory.getLogger(TenantCacheEntry.class);
    private static ThreadGroup UPDATER_THREAD_GROUP = new ThreadGroup("Cache updaters");
    private TenantCacheValueReader<T> valueReader;
    private String tenant;
    private T value;
    private long valueTimestamp;
    private long lastAccessTimestamp;
    private boolean updateTriggered = false;
    private TenantCacheConfiguration tenantCacheConfig;

    public TenantCacheEntry(TenantCacheConfiguration tenantCacheConfig, String tenant, TenantCacheValueReader<T> valueReader) {
        this.tenant = tenant;
        this.valueReader = valueReader;
        this.tenantCacheConfig = tenantCacheConfig;
    }

    public long getLastAccessTimestamp() {
        return this.lastAccessTimestamp;
    }

    public synchronized T getValue() {
        long currentTime = System.currentTimeMillis();
        if (!this.updateTriggered && currentTime - this.valueTimestamp >= this.tenantCacheConfig.getValueTimeout()) {
            if (currentTime - this.lastAccessTimestamp >= this.tenantCacheConfig.getLastAccessTimeout()) {
                LOG.debug("Triggering synchronous cache update for tenant [{}].", (Object)this.tenant);
                this.updateCache();
            } else {
                LOG.debug("Triggering asynchronous cache update for tenant [{}].", (Object)this.tenant);
                this.updateTriggered = true;
                new Thread(UPDATER_THREAD_GROUP, this).start();
            }
        }
        this.lastAccessTimestamp = currentTime;
        return this.value;
    }

    private void updateCache() {
        LOG.debug("Starting cache update for tenant [{}] using value reader [{}].", (Object)this.tenant, (Object)this.valueReader.getClass().getSimpleName());
        this.value = this.valueReader.readValue(this.tenant, this.value);
        this.valueTimestamp = System.currentTimeMillis();
        LOG.debug("Successful cache update for tenant [{}] using value reader [{}].", (Object)this.tenant, (Object)this.valueReader.getClass().getSimpleName());
    }

    @Override
    public void run() {
        try {
            try {
                if (RuntimeUtils.isRunningInOsgi()) {
                    this.callInheritFromParentInOsgi();
                } else {
                    this.callInheritFromParentInNonOsgi();
                }
            }
            catch (IllegalStateException ise) {
                LOG.debug("Could not inherit the tenant from the parent thread. Will not attempt to trigger another update until the cache is expired!", (Throwable)ise);
                this.updateTriggered = false;
                this.valueTimestamp = System.currentTimeMillis();
                return;
            }
            try {
                this.updateCache();
            }
            catch (Exception e) {
                LOG.error("Failed to asyncrhonously update the cache", (Throwable)e);
            }
        }
        finally {
            this.updateTriggered = false;
            this.valueTimestamp = System.currentTimeMillis();
        }
    }

    public void callInheritFromParentInOsgi() {
        if (Thread.currentThread().getThreadGroup() == UPDATER_THREAD_GROUP) {
            Tenant.inheritFromParentThread();
            LOG.debug("Cache updater thread will use the tenant propagated from the parent thread: {}", (Object)Tenant.getId());
        } else {
            LOG.debug("Cache updater invoked in an unexpected thread and will not use tenant propageted from the parent thread but provider account tenant: {}", (Object)Tenant.getId());
        }
    }

    public void callInheritFromParentInNonOsgi() {
        ClassLoader loader = ClassloadingBridge.getImplClassLoader();
        try {
            Class<?> tenantClass = loader.loadClass("com.sap.core.tenant.api.Tenant");
            Method getIdMethod = tenantClass.getMethod("getId", new Class[0]);
            if (Thread.currentThread().getThreadGroup() == UPDATER_THREAD_GROUP) {
                Method inheritFromParentThreadMethod = tenantClass.getMethod("inheritFromParentThread", new Class[0]);
                inheritFromParentThreadMethod.invoke(null, new Object[0]);
                LOG.debug("Cache updater thread will use the tenant propagated from the parent thread: {}", getIdMethod.invoke(null, new Object[0]));
            } else {
                LOG.debug("Cache updater invoked in an unexpected thread and will not use tenant propageted from the parent thread but provider account tenant: {}", getIdMethod.invoke(null, new Object[0]));
            }
        }
        catch (Exception exception) {
            LOG.error(String.format("Failed to run cache updater thread in non osgi environment. Fail message: [%s]", exception.getMessage()), (Throwable)exception);
        }
    }
}

