/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connectivity.ConnectivityConfigurationUtil;
import com.sap.core.jpaas.security.utils.connectivity.ConnectivityException;
import java.security.KeyStore;

public class Destination {
    private static final String SYSTEM_PROXY_KEY = "SystemProxy";
    private final String destinationName;
    private DestinationConfiguration configuration;

    public Destination(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getSystemProxy() {
        this.initConfiguration();
        return this.configuration.getProperty(SYSTEM_PROXY_KEY);
    }

    public String getURL() {
        this.initConfiguration();
        return this.configuration.getProperty("URL");
    }

    public KeyStore getKeyStore() {
        this.initConfiguration();
        return this.configuration.getKeyStore();
    }

    public String getKeyStorePassword() {
        this.initConfiguration();
        return this.configuration.getProperty("KeyStorePassword");
    }

    public String getAuthenticationType() {
        this.initConfiguration();
        return this.configuration.getProperty("Authentication");
    }

    public String getUserName() {
        this.initConfiguration();
        return this.configuration.getProperty("User");
    }

    public String getUserPassword() {
        this.initConfiguration();
        return this.configuration.getProperty("Password");
    }

    public String toString() {
        return this.destinationName;
    }

    private void initConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
        }
    }

    private DestinationConfiguration createConfiguration() {
        try {
            return this.getDestinationConfiguration();
        }
        catch (ConnectivityException e) {
            throw new ConnectionException("Error while gettting destination configuration for [" + this.destinationName + "] destination.", e);
        }
    }

    DestinationConfiguration getDestinationConfiguration() throws ConnectivityException {
        return ConnectivityConfigurationUtil.getDestinationConfiguration(this.destinationName);
    }
}

