/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.Connection;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.RequestAttributes;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProvider;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProviderFactory;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.core.jpaas.security.utils.connection.impl.URLResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationURLConnection
implements Connection<HttpURLConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DestinationURLConnection.class);
    private final String destinationName;

    public DestinationURLConnection(String name) {
        this.destinationName = name;
    }

    @Override
    public Response execute(Request<HttpURLConnection> request) throws ConnectionException {
        URLRequest urlRequest = (URLRequest)request;
        try {
            HttpURLConnection connection = this.createConnection(urlRequest);
            connection = urlRequest.configure(connection);
            LOGGER.debug("Executing request: [{}]", (Object)urlRequest);
            connection.connect();
            URLResponse urlResponse = new URLResponse(connection);
            LOGGER.debug("Received status code: {}", (Object)urlResponse.getStatus());
            return urlResponse;
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to open connection to " + urlRequest.getPath(), e);
        }
    }

    HttpURLConnection createConnection(RequestAttributes attributes) throws IOException {
        HttpURLConnectionProvider provider = new HttpURLConnectionProviderFactory(this.destinationName).create();
        return provider.createHttpsURLConnection(attributes.getPath());
    }
}

