/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.impl.Destination;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HttpURLConnectionProvider {
    private static final int READ_TIMEOUT = 30000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final Logger logger = LoggerFactory.getLogger(HttpURLConnectionProvider.class);
    Destination destination;

    public HttpURLConnectionProvider(Destination destination) {
        logger.debug("Creating HttpURLConnectionProvider for destination with name {}", (Object)destination);
        this.destination = destination;
    }

    protected abstract void addAdditionalPropertiesToURLConnection(HttpURLConnection var1) throws IOException;

    protected HttpURLConnection createHttpsURLConnection(String path) throws IOException {
        logger.debug("Creating HttpsURLConnection with path [{}]", (Object)path);
        HttpURLConnection httpsURLConnection = this.createHttpURLConnection(path);
        this.addAdditionalPropertiesToURLConnection(httpsURLConnection);
        return httpsURLConnection;
    }

    private HttpURLConnection createHttpURLConnection(String path) throws IOException {
        Proxy proxy = this.createProxyConfiguration();
        return this.openConnection(new URL(this.constructURL(path)), proxy);
    }

    private Proxy createProxyConfiguration() throws IOException {
        String proxyConfiguration = this.destination.getSystemProxy();
        if (proxyConfiguration == null || proxyConfiguration.trim().isEmpty()) {
            return Proxy.NO_PROXY;
        }
        String[] hostAndPort = proxyConfiguration.split(":");
        if (hostAndPort.length != 2) {
            throw new IOException("Proxy configuration is not valid [" + proxyConfiguration + "]");
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
    }

    private String constructURL(String path) throws IOException {
        if (path.startsWith("/") || path.startsWith("?")) {
            return String.format("%s%s", this.destination.getURL(), path);
        }
        if (path.isEmpty()) {
            return this.destination.getURL();
        }
        return String.format("%s/%s", this.destination.getURL(), path);
    }

    private HttpURLConnection openConnection(URL url, Proxy proxy) throws IOException {
        logger.debug("Opening connection to URL {} with proxy {}", (Object)url, (Object)proxy);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(proxy);
        this.configureTimeoutToURLConnection(urlConnection);
        return urlConnection;
    }

    private void configureTimeoutToURLConnection(HttpURLConnection urlConnection) {
        urlConnection.setReadTimeout(30000);
        urlConnection.setConnectTimeout(30000);
    }
}

