/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.impl.Destination;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpURLConnectionProviderClientCertAuthn
extends HttpURLConnectionProvider {
    private static final String TLS_PROTOCOL = "TLS";
    private static final String SUN_X509_ALGORITHM = "SunX509";
    private static final Logger logger = LoggerFactory.getLogger(HttpURLConnectionProviderClientCertAuthn.class);

    public HttpURLConnectionProviderClientCertAuthn(Destination destination) {
        super(destination);
    }

    @Override
    protected void addAdditionalPropertiesToURLConnection(HttpURLConnection httpURLConnection) throws IOException {
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            try {
                this.addSSLPropertiesToURLConnection(httpsURLConnection);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private void addSSLPropertiesToURLConnection(HttpsURLConnection urlConnection) throws Exception {
        KeyManager[] keyManagers = this.getKeyManagers();
        if (keyManagers == null) {
            return;
        }
        SSLContext sslContext = SSLContext.getInstance(TLS_PROTOCOL);
        sslContext.init(keyManagers, null, null);
        urlConnection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    private KeyManager[] getKeyManagers() throws Exception {
        KeyStore keystore = this.destination.getKeyStore();
        if (keystore == null) {
            logger.debug("No keystore found in the destination so the call will be made without a client certificate");
            return null;
        }
        String password = this.destination.getKeyStorePassword();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(SUN_X509_ALGORITHM);
        keyManagerFactory.init(keystore, password.toCharArray());
        logger.debug("Keystore used for client certificate authentication: {} ", (Object)keystore);
        return keyManagerFactory.getKeyManagers();
    }
}

