/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.impl.DefaultHttpURLConnectionProvider;
import com.sap.core.jpaas.security.utils.connection.impl.Destination;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProvider;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProviderBasicAuthn;
import com.sap.core.jpaas.security.utils.connection.impl.HttpURLConnectionProviderClientCertAuthn;

class HttpURLConnectionProviderFactory {
    static final String AUTHENTICATION_TYPE_BASIC = "BasicAuthentication";
    static final String AUTHENTICATION_TYPE_CLIENT_CERT = "ClientCertificateAuthentication";
    static final String AUTHENTICATION_TYPE_INTERNAL_SYSTEM = "InternalSystemAuthentication";
    private Destination destination;

    public HttpURLConnectionProviderFactory(String destinationName) {
        this(new Destination(destinationName));
    }

    public HttpURLConnectionProviderFactory(Destination destination) {
        this.destination = destination;
    }

    public HttpURLConnectionProvider create() {
        if (this.isAuthenticationType(AUTHENTICATION_TYPE_CLIENT_CERT) || this.isAuthenticationType(AUTHENTICATION_TYPE_INTERNAL_SYSTEM)) {
            return new HttpURLConnectionProviderClientCertAuthn(this.destination);
        }
        if (this.isAuthenticationType(AUTHENTICATION_TYPE_BASIC)) {
            return new HttpURLConnectionProviderBasicAuthn(this.destination);
        }
        return new DefaultHttpURLConnectionProvider(this.destination);
    }

    private boolean isAuthenticationType(String authenticationType) {
        return authenticationType.equals(this.destination.getAuthenticationType());
    }
}

