/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.AuditLogMode;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public abstract class RequestBuilder<T> {
    private static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String CLIENT_USER_HEADER_NAME = "CLIENT_USER";
    protected String path;
    protected String method;
    protected byte[] entity;
    protected String contentType = "application/json; charset=utf-8";
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, String> queryParams = new HashMap<String, String>();

    public RequestBuilder<T> withMethod(String method) {
        this.method = method;
        return this;
    }

    public RequestBuilder<T> withGETMethod() {
        this.method = "GET";
        return this;
    }

    public RequestBuilder<T> withPOSTMethod() {
        this.method = "POST";
        return this;
    }

    public RequestBuilder<T> withPUTMethod() {
        this.method = "PUT";
        return this;
    }

    public RequestBuilder<T> withDELETEMethod() {
        this.method = "DELETE";
        return this;
    }

    public RequestBuilder<T> withPath(URI path) {
        this.path = path.toString();
        return this;
    }

    public RequestBuilder<T> withPath(String path) {
        this.path = path;
        return this;
    }

    public RequestBuilder<T> withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public RequestBuilder<T> withQueryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public RequestBuilder<T> withAuditLog(AuditLogMode auditLogMode) {
        String[] stringArray = auditLogMode.getHeaderNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String headerName = stringArray[n2];
            this.headers.put(headerName, String.valueOf(Boolean.TRUE));
            ++n2;
        }
        return this;
    }

    public RequestBuilder<T> withClientUser(String user) {
        this.headers.put(CLIENT_USER_HEADER_NAME, user);
        return this;
    }

    public RequestBuilder<T> withEntity(byte[] entity) {
        this.entity = entity;
        return this;
    }

    public RequestBuilder<T> withEntity(String entity) {
        this.entity = entity.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public RequestBuilder<T> withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public abstract T build();
}

