/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.RequestAttributes;
import com.sap.core.jpaas.security.utils.connection.impl.RequestBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Collections;
import java.util.Map;

public class URLRequest
implements Request<HttpURLConnection>,
RequestAttributes {
    private static final String APPLICATION_JSON = "application/json";
    private static final String EMPTY_PATH = "";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String PROPERTY_CONTENT_TYPE = "Content-Type";
    private String path;
    private String method;
    private byte[] entity;
    private String contentType;
    private Map<String, String> headers;

    public URLRequest() {
        this(EMPTY_PATH, REQUEST_METHOD_GET, APPLICATION_JSON, null, Collections.emptyMap());
    }

    public URLRequest(String path, String method, String contentType, byte[] entity, Map<String, String> headers) {
        this.path = path == null ? EMPTY_PATH : path;
        this.method = method;
        this.contentType = contentType;
        this.entity = entity;
        this.headers = headers;
    }

    @Override
    public HttpURLConnection configure(HttpURLConnection connection) {
        this.configureMethod(connection);
        this.configureHeaders(connection);
        this.configureBody(connection);
        return connection;
    }

    private void configureMethod(HttpURLConnection connection) {
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new ConnectionException("Failed to configure method of the connection.", e);
        }
    }

    private void configureHeaders(HttpURLConnection connection) {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
    }

    private void configureBody(HttpURLConnection connection) {
        if (this.entity != null) {
            try {
                connection.setDoOutput(true);
                connection.setRequestProperty(PROPERTY_CONTENT_TYPE, this.contentType);
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(this.entity);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new ConnectionException("Failed to configure the request body of the connection.", e);
            }
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "URLRequest [path=" + this.path + ", method=" + this.method + ", contentType=" + this.contentType + ", headers=" + this.headers + "]";
    }

    public static class Builder
    extends RequestBuilder<URLRequest> {
        @Override
        public URLRequest build() {
            return new URLRequest(this.constructPathWithQueryParams(), this.method, this.contentType, this.entity, this.headers);
        }

        private String constructPathWithQueryParams() {
            if (this.queryParams.isEmpty()) {
                return this.path;
            }
            StringBuilder builder = this.path == null ? new StringBuilder() : new StringBuilder(this.path);
            builder.append("?");
            for (Map.Entry queryParam : this.queryParams.entrySet()) {
                builder.append((String)queryParam.getKey()).append("=").append((String)queryParam.getValue());
            }
            return builder.toString();
        }
    }
}

