/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connection.impl;

import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class URLResponse
implements Response {
    private final HttpURLConnection connection;

    public URLResponse(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public int getStatus() {
        try {
            return this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public boolean isOK() {
        return this.getStatus() == 200;
    }

    @Override
    public boolean isNotOK() {
        return !this.isOK();
    }

    @Override
    public boolean is(int statusCode) {
        return this.getStatus() == statusCode;
    }

    @Override
    public boolean isNot(int statusCode) {
        return !this.is(statusCode);
    }

    @Override
    public String asString() {
        InputStream inputStream = this.asInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            return this.inputStreamToString(inputStream);
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to convert input stream to string.", e);
        }
    }

    private String inputStreamToString(InputStream input) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int counter = -1;
        while ((counter = input.read(buffer, 0, buffer.length)) != -1) {
            bytesOut.write(buffer, 0, counter);
        }
        return new String(bytesOut.toByteArray(), "UTF-8");
    }

    @Override
    public InputStream asInputStream() {
        try {
            if (this.isErrorCode()) {
                return this.connection.getErrorStream();
            }
            return this.connection.getInputStream();
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to get response input stream.", e);
        }
    }

    @Override
    public String getHeader(String key) {
        return this.connection.getHeaderField(key);
    }

    @Override
    public List<String> getHeaderValues(String key) {
        List<String> headers = this.connection.getHeaderFields().get(key);
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers;
    }

    private boolean isErrorCode() {
        return this.getStatus() >= 400;
    }

    @Override
    public void consume() {
        this.connection.disconnect();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append("UrlResponse: [");
            builder.append("\nStatus code: ").append(this.connection.getResponseCode());
            builder.append("\nHeaders: ").append(this.connection.getHeaderFields());
            if (this.connection.getContentLength() == 0) {
                builder.append("\nThe response has no body.");
            } else {
                builder.append("\nThe response has body.");
            }
            builder.append("]");
        }
        catch (IOException e) {
            throw new ConnectionException("Failed to build response for tracing.", e);
        }
        return builder.toString();
    }

    @Override
    public Collection<String> getHeaderKeys() {
        return this.connection.getHeaderFields().keySet();
    }
}

