/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.connectivity;

import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.jpaas.security.utils.Base64;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.core.jpaas.security.utils.connectivity.ConnectivityException;
import com.sap.core.jpaas.security.utils.connectivity.DestinationDescriptor;
import com.sap.core.jpaas.security.utils.umhelper.UserGroupsFactory;
import com.sap.core.tenant.api.Tenant;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityConfigurationUtil {
    private static final String UTF_8 = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectivityConfigurationUtil.class);
    static final String HTTPS_URL_PREFIX = "https";
    static final String AUTHENTICATION_TYPE_CLIENT_CERT = "ClientCertificateAuthentication";
    static final String CONNECIVITY_ONPREMISE_ACCOUNT_HEADER = "SAP-Connectivity-ConsumerAccount";
    static final String AUTHENTICATION_TYPE_BASIC = "BasicAuthentication";
    static final String AUTHENTICATION_TYPE_NONE = "NoAuthentication";
    static final String DESTINATION_PROP_PASSWORD = "Password";
    static final String DESTINATION_PROP_USER = "User";
    static final String DESTINATION_PROP_KEYSTORE_PASSWORD = "KeyStorePassword";
    static final String DESTINATION_PROXY_TYPE_ONPREMISE = "OnPremise";
    static final String DESTINATION_PROP_PROXY_TYPE = "ProxyType";
    static final String DESTINATION_PROP_AUTHENTICATION = "Authentication";
    static final String AUTHORIZATION = "Authorization";
    static final String DESTINATION_PROP_URL = "URL";
    private static String onPremiseProxyHost;
    private static int onPremiseProxyPort;
    private static ConnectivityConfiguration connectivityConfiguration;

    static {
        onPremiseProxyPort = 0;
    }

    @Deprecated
    public static void bindConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        ConnectivityConfigurationUtil.connectivityConfiguration = connectivityConfiguration;
    }

    @Deprecated
    public static void unbindConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        ConnectivityConfigurationUtil.connectivityConfiguration = null;
    }

    public void bindConnectivityConfiguration2(ConnectivityConfiguration connectivityConfiguration) {
        ConnectivityConfigurationUtil.connectivityConfiguration = connectivityConfiguration;
    }

    public void unbindConnectivityConfiguration2(ConnectivityConfiguration connectivityConfiguration) {
        ConnectivityConfigurationUtil.connectivityConfiguration = null;
    }

    public static HttpURLConnection getHttpUrlConnection(String destinationName) throws ConnectivityException {
        return ConnectivityConfigurationUtil.getHttpUrlConnection(destinationName, null, null);
    }

    public static HttpURLConnection getHttpUrlConnection(String destinationName, String urlSuffix) throws ConnectivityException {
        return ConnectivityConfigurationUtil.getHttpUrlConnection(destinationName, urlSuffix, null);
    }

    public static HttpURLConnection getHttpUrlConnection(String destinationName, String urlSuffix, Map<String, String> queryParameters) throws ConnectivityException {
        LOGGER.debug("Getting HttpURLConnection for destination [{}], with URL suffix [{}] and queryParameters [{}]", new Object[]{destinationName, urlSuffix, queryParameters});
        DestinationDescriptor destination = ConnectivityConfigurationUtil.getDestinationProperties(destinationName);
        HttpURLConnection connection = null;
        try {
            String finalURL = ConnectivityConfigurationUtil.buildRequestLine(destination.getUrl(), urlSuffix, queryParameters);
            URL url = new URL(finalURL);
            if (DESTINATION_PROXY_TYPE_ONPREMISE.equals(destination.getProxyType())) {
                connection = (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ConnectivityConfigurationUtil.getOnPremiseProxyHost(), ConnectivityConfigurationUtil.getOnPremiseProxyPort())));
                connection.addRequestProperty(CONNECIVITY_ONPREMISE_ACCOUNT_HEADER, Tenant.getAccountName());
                LOGGER.debug("Created Url Connection to destination [{}] with proxy: [{}:{}]", new Object[]{url, onPremiseProxyHost, onPremiseProxyPort});
                LOGGER.debug("Added header 'SAP-Connectivity-ConsumerAccount' with value [{}]]", (Object)Tenant.getAccountName());
            } else {
                connection = (HttpURLConnection)url.openConnection();
                LOGGER.debug("Created Url Connection to destination [{}] with system proxy settings", (Object)destination.getUrl());
            }
            if (destination.getUrl().startsWith(HTTPS_URL_PREFIX)) {
                ConnectivityConfigurationUtil.addSSLProperties((HttpsURLConnection)connection, destination);
            }
        }
        catch (MalformedURLException e) {
            throw new ConnectivityException("Could not use location url: " + destination.getUrl(), e);
        }
        catch (IOException e) {
            throw new ConnectivityException("Communication error during the attempt to open connection to url: " + destination.getUrl(), e);
        }
        if (AUTHENTICATION_TYPE_BASIC.equals(destination.getAuthenticationType())) {
            String authorizationValue = String.valueOf(destination.getUserName()) + ":" + destination.getPassword();
            connection.setRequestProperty(AUTHORIZATION, "Basic " + Base64.encode(authorizationValue.getBytes(Charset.forName(UTF_8))));
        }
        LOGGER.debug("Created HttpURLConnection for destination [{}], with URL suffix [{}] and queryParameters [{}]", new Object[]{destinationName, urlSuffix, queryParameters});
        return connection;
    }

    public static DestinationDescriptor getDestinationProperties(String destinationName) throws ConnectivityException {
        LOGGER.debug("Getting DestinationDescriptor for destination [{}]", (Object)destinationName);
        ConnectivityConfigurationUtil.initConnectivityConfigurationNonOSGIRuntime();
        DestinationConfiguration destinationCfg = ConnectivityConfigurationUtil.getDestinationConfiguration(destinationName);
        String url = destinationCfg.getProperty(DESTINATION_PROP_URL);
        String authenticationType = destinationCfg.getProperty(DESTINATION_PROP_AUTHENTICATION);
        String proxyType = destinationCfg.getProperty(DESTINATION_PROP_PROXY_TYPE);
        DestinationDescriptor toReturn = null;
        if (AUTHENTICATION_TYPE_BASIC.equals(authenticationType)) {
            String userName = destinationCfg.getProperty(DESTINATION_PROP_USER);
            String password = destinationCfg.getProperty(DESTINATION_PROP_PASSWORD);
            if (userName == null || userName.equals("") || password == null || password.equals("")) {
                throw new ConnectivityException("No user name or passowrd defined for destination: " + destinationName);
            }
            KeyStore trustStore = destinationCfg.getTrustStore();
            toReturn = new DestinationDescriptor(destinationName, url, userName, password, proxyType, trustStore, authenticationType);
            LOGGER.debug("Destination configuration for authenticatio type basic loaded [{}]", (Object)toReturn);
        } else if (AUTHENTICATION_TYPE_CLIENT_CERT.equals(authenticationType)) {
            KeyStore keyStore = destinationCfg.getKeyStore();
            KeyStore trustStore = destinationCfg.getTrustStore();
            String keyStorePassword = destinationCfg.getProperty(DESTINATION_PROP_KEYSTORE_PASSWORD);
            if (keyStore == null) {
                throw new ConnectivityException("No Keystore defined for destination: " + destinationName);
            }
            if (keyStorePassword == null) {
                throw new ConnectivityException("No Keystore password defined for destination: " + destinationName);
            }
            toReturn = new DestinationDescriptor(destinationName, url, proxyType, keyStore, trustStore, keyStorePassword);
            LOGGER.debug("Destination configuration for authentication type client cert loaded [{}]", (Object)toReturn);
        } else if (AUTHENTICATION_TYPE_NONE.equals(authenticationType)) {
            toReturn = new DestinationDescriptor(destinationName, url, proxyType, null, null, null);
            LOGGER.debug("Destination configuration for authenticatio type none [{}]", (Object)toReturn);
        } else {
            throw new ConnectivityException("Authentication type " + authenticationType + " not supported");
        }
        LOGGER.debug("Done getting DestinationDescriptor for destination [{}]. Result is [{}]", (Object)destinationName, (Object)toReturn);
        return toReturn;
    }

    public static DestinationConfiguration getDestinationConfiguration(String destinationName) throws ConnectivityException {
        ConnectivityConfigurationUtil.initConnectivityConfigurationNonOSGIRuntime();
        if (connectivityConfiguration == null) {
            throw new ConnectivityException("Could not obtain reference to connectivity - cannot retrieve destination details");
        }
        DestinationConfiguration destinationCfg = connectivityConfiguration.getConfiguration(destinationName);
        if (destinationCfg == null) {
            LOGGER.debug("Destination with name [{}] does not exist", (Object)destinationName);
            throw new ConnectivityException("No destination configured for [" + destinationName + "]");
        }
        return destinationCfg;
    }

    private static String buildRequestLine(String destinationUrl, String urlSuffix, Map<String, String> queryParameters) {
        LOGGER.debug("Building request line. URL from destination is [{}], added suffix is [{}], query parameters to add [{}]", new Object[]{destinationUrl, urlSuffix, queryParameters});
        if (urlSuffix != null && urlSuffix.contains("?")) {
            throw new IllegalArgumentException("Question mark is not a valid in URL suffix. Use the 'queryParameters' parameter if you want to provide query parameters");
        }
        StringBuilder urlBuilder = new StringBuilder(destinationUrl);
        if (urlSuffix != null) {
            urlBuilder.append(urlSuffix);
        }
        if (queryParameters != null && queryParameters.size() > 0) {
            urlBuilder.append("?");
            Iterator<String> keys = queryParameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                urlBuilder.append(key);
                urlBuilder.append("=");
                try {
                    urlBuilder.append(URLEncoder.encode(queryParameters.get(key), UTF_8));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Encoding UTF-8 is not supported", e);
                }
                if (!keys.hasNext()) continue;
                urlBuilder.append("&");
            }
        }
        String result = urlBuilder.toString();
        LOGGER.debug("Built request line: [{}]", (Object)result);
        return result;
    }

    private static void addSSLProperties(HttpsURLConnection connection, DestinationDescriptor destination) throws ConnectivityException {
        LOGGER.debug("Configuring SSL properties for destination [{}]", (Object)destination.getDestinationName());
        try {
            KeyStore keystore = destination.getKeyStore();
            KeyStore trustStore = destination.getTrustStore();
            if (keystore == null && trustStore == null) {
                LOGGER.debug("No keystore and trust store defined for destination [{}]. Will not configure any SSL settings.", (Object)destination.getDestinationName());
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = null;
            if (trustStore != null) {
                TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmfactory.init(trustStore);
                trustManagers = tmfactory.getTrustManagers();
                LOGGER.debug("Configured custom trust store for destination [{}]", (Object)destination.getDestinationName());
            }
            KeyManager[] keyManagers = null;
            if (keystore != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keystore, destination.getKeyStorePassword().toCharArray());
                keyManagers = keyManagerFactory.getKeyManagers();
                LOGGER.debug("Configured custom keystore store for destination [{}]", (Object)destination.getDestinationName());
            }
            sslContext.init(keyManagers, trustManagers, null);
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            LOGGER.debug("Done configuring SSL properties for destination [{}]", (Object)destination.getDestinationName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConnectivityException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new ConnectivityException(e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new ConnectivityException(e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new ConnectivityException(e.getMessage(), e);
        }
    }

    private static String getOnPremiseProxyHost() {
        if (onPremiseProxyHost == null) {
            onPremiseProxyHost = System.getenv("HC_OP_HTTP_PROXY_HOST");
            LOGGER.debug("Resolved scc proxy host to [{}]", (Object)onPremiseProxyHost);
        }
        return onPremiseProxyHost;
    }

    private static int getOnPremiseProxyPort() {
        if (onPremiseProxyPort == 0) {
            try {
                onPremiseProxyPort = Integer.parseInt(System.getenv("HC_OP_HTTP_PROXY_PORT"));
                LOGGER.debug("Resolved scc proxy port to [{}]", (Object)onPremiseProxyPort);
            }
            catch (NumberFormatException nfe) {
                LOGGER.debug("Invalid value of onpremise proxy port: [" + onPremiseProxyPort + "]", (Throwable)nfe);
            }
        }
        return onPremiseProxyPort;
    }

    private static void initConnectivityConfigurationNonOSGIRuntime() {
        if (connectivityConfiguration == null && RuntimeUtils.isRunningInNonOsgi()) {
            connectivityConfiguration = UserGroupsFactory.getConnectivityConfiguration();
        }
    }
}

