/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.gson;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.core.jpaas.security.utils.gson.GsonParser;
import com.sap.core.jpaas.security.utils.gson.GsonParserImpl;

public class GsonParserFactory {
    private static final String TOMCAT_RUNTIME_GSON_PARSER_IMPLEMENTATION = "com.sap.security.auth.util.GsonParserImpl";
    private static GsonParser gsonParser;

    public static GsonParser getGsonParserInstance() {
        if (gsonParser == null) {
            gsonParser = GsonParserFactory.createParserInstance();
        }
        return gsonParser;
    }

    private static GsonParser createParserInstance() {
        if (RuntimeUtils.isRunningInOsgi()) {
            return new GsonParserImpl();
        }
        return GsonParserFactory.createParserInstanceForTomcat();
    }

    private static GsonParser createParserInstanceForTomcat() {
        try {
            Class<?> clazz = ClassloadingBridge.getImplClassLoader().loadClass(TOMCAT_RUNTIME_GSON_PARSER_IMPLEMENTATION);
            gsonParser = (GsonParser)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find instance of the GsonParser", e);
        }
        return gsonParser;
    }
}

