/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.otp;

import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DestinationURLConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.core.jpaas.security.utils.otp.PasscodeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasscodeChecker {
    static final String X_MESSAGE_CODE_HEADER_KEY = "X-message-code";
    private static final String APPLICATION_JSON = "application/json";
    private static final String PASSCODE_TEMPLATE = "{\"userName\": \"%s\",\"otpCode\": \"%s\"}";
    private static final String DESTINATION_NAME = "otpservice";
    private static final Logger logger = LoggerFactory.getLogger(PasscodeChecker.class);
    private static final PasscodeChecker INSTANCE = new PasscodeChecker();

    public static PasscodeChecker getInstance() {
        return INSTANCE;
    }

    PasscodeChecker() {
    }

    public void checkUserPasscode(String userID, String passcode) throws PasscodeException {
        logger.info("Checking passcode for user [{}]", (Object)passcode, (Object)userID);
        try {
            if (!this.isPasscodeValid(userID, passcode)) {
                throw new PasscodeException("Passcode is invalid.");
            }
            logger.info("Passcode is validated successfully.");
        }
        catch (ConnectionException exception) {
            throw new PasscodeException("Unexcepted exception occur while trying to validate passcode.", exception);
        }
    }

    private boolean isPasscodeValid(String userName, String passcode) throws ConnectionException, PasscodeException {
        DestinationURLConnection connection = this.createDestinationURLConnection();
        URLRequest request = this.createURLRequest(userName, passcode);
        Response response = null;
        try {
            response = connection.execute(request);
            if (!response.isOK()) {
                logger.error(this.prepareErrorMessage(response));
                return false;
            }
            return true;
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    String prepareErrorMessage(Response response) {
        String messageCode = response.getHeader(X_MESSAGE_CODE_HEADER_KEY);
        String errorMessage = String.format("Unexpected status code returned from SCI. Status code: [%s]. Message code: [%s]. Message: [%s]", response.getStatus(), messageCode, response.toString());
        return errorMessage;
    }

    DestinationURLConnection createDestinationURLConnection() {
        return new DestinationURLConnection(DESTINATION_NAME);
    }

    private URLRequest createURLRequest(String userName, String passcode) {
        URLRequest.Builder builder = new URLRequest.Builder();
        builder.withPOSTMethod().withContentType(APPLICATION_JSON);
        String requestBody = this.prepareRequestBody(userName, passcode);
        builder.withEntity(requestBody);
        return builder.build();
    }

    private String prepareRequestBody(String userName, String passcode) {
        return String.format(PASSCODE_TEMPLATE, userName, passcode);
    }
}

