/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.jpaas.security.utils.umhelper;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.jpaas.security.utils.RuntimeUtils;
import com.sap.core.jpaas.security.utils.umhelper.UserGroupsService;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupsFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(UserGroupsFactory.class);
    private static UserGroupsFactory INSTANCE = null;
    private UserGroupsService service = null;

    public void registerUserGroupsService(UserGroupsService service) {
        this.service = service;
    }

    public void unregisterUserGroupsService() {
        this.service = null;
    }

    public UserGroupsService getUserGroupsService() {
        return this.service;
    }

    public static UserGroupsFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserGroupsFactory();
            INSTANCE.initializeUserGroupsService();
        }
        return INSTANCE;
    }

    private void initializeUserGroupsService() {
        if (!RuntimeUtils.isRunningInOsgi()) {
            LOGGER.debug("Searching for UserGroupsService as a java service");
            ServiceLoader<UserGroupsService> loader = ServiceLoader.load(UserGroupsService.class, ClassloadingBridge.getImplClassLoader());
            Iterator<UserGroupsService> iterator = loader.iterator();
            if (iterator.hasNext()) {
                this.service = iterator.next();
            } else {
                LOGGER.error("Cannot locate any UserGroupsService implementation");
            }
        } else {
            LOGGER.debug("Searching for UserGroupsService as an osgi service");
        }
    }

    public static ConnectivityConfiguration getConnectivityConfiguration() {
        ServiceLoader<ConnectivityConfiguration> loader = ServiceLoader.load(ConnectivityConfiguration.class, ClassloadingBridge.getImplClassLoader());
        Iterator<ConnectivityConfiguration> iterator = loader.iterator();
        if (iterator.hasNext()) {
            ConnectivityConfiguration connectivityCfg = iterator.next();
            return connectivityCfg;
        }
        LOGGER.error("There was no ConnectivityConfiguration registered.");
        return null;
    }
}

