/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.management.TracingConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TracingConfigurationChangeEvent;
import com.sap.core.connectivity.tunnel.api.management.TracingConfigurationChangeListener;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.impl.context.PayloadTracerEvent;
import com.sap.core.connectivity.tunnel.core.timeout.FutureTimeout;
import com.sap.core.connectivity.tunnel.core.timeout.FutureTimeoutListener;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import com.sap.core.connectivity.tunnel.core.util.SCCVersion;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class Tunnel
implements Comparable<Tunnel> {
    private static final Logger log = Logger.getLogger(Tunnel.class);
    private final String clientId;
    private final String tunnelId;
    private final TracingConfiguration tracingConfiguration;
    private final List<Channel> tunnelChannels = Collections.synchronizedList(new ArrayList());
    private final Map<Channel, Date> creationDates = new ConcurrentHashMap<Channel, Date>();
    private final Map<Integer, Channel> channelSubscriptions = new ConcurrentHashMap<Integer, Channel>();
    private final Map<Integer, TunnelRequestFuture> requestFutures = new ConcurrentHashMap<Integer, TunnelRequestFuture>();
    private int currentChannel = 0;
    private final TraceConfigurationChangeListener configurationListener = new TraceConfigurationChangeListener();
    private SCCVersion masterVersion;
    private SCCVersion shadowVersion;

    public Tunnel(String tunnelId, String clientId, ConnectivityContext context) {
        if (tunnelId == null) {
            throw new IllegalArgumentException("Always use a non-null tunnel ID when creating a tunnel");
        }
        this.tunnelId = tunnelId;
        this.clientId = clientId;
        this.tracingConfiguration = (TracingConfiguration)context.getServiceRegistry().getService(TracingConfiguration.class);
        this.tracingConfiguration.addListener((TracingConfigurationChangeListener)this.configurationListener);
    }

    public String getId() {
        return this.tunnelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("You can only add a valid channel");
        }
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            if (this.tracingConfiguration.isTracingEnabled(this.tunnelId)) {
                this.enableTracing(channel);
            }
            this.tunnelChannels.add(channel);
            this.creationDates.put(channel, new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> remove(Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException("You can only remove a valid channel");
        }
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            this.tunnelChannels.remove(channel);
            this.creationDates.remove(channel);
        }
        Iterator<Map.Entry<Integer, Channel>> subscriptionsIterator = this.channelSubscriptions.entrySet().iterator();
        ArrayList<Integer> removedSubscriptions = new ArrayList<Integer>();
        while (subscriptionsIterator.hasNext()) {
            Map.Entry<Integer, Channel> channelEntry = subscriptionsIterator.next();
            if (!channelEntry.getValue().equals(channel)) continue;
            subscriptionsIterator.remove();
            removedSubscriptions.add(channelEntry.getKey());
        }
        return removedSubscriptions;
    }

    public int getChannelCount() {
        return this.tunnelChannels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel subscribe(int connectionId) throws NoChannelsAvailableException {
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            if (this.tunnelChannels.size() == 0) {
                throw new NoChannelsAvailableException();
            }
            if (this.currentChannel > this.tunnelChannels.size() - 1) {
                this.currentChannel = 0;
            }
            Channel channel = this.tunnelChannels.get(this.currentChannel);
            this.channelSubscriptions.put(connectionId, channel);
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("Subscribed connection with id: {0} to tunnel channel {1}. Tunnel id: \"{2}\"", ChannelUtil.formatConnectionId((int)connectionId), channel, this.tunnelId));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)this.toString());
            }
            ++this.currentChannel;
            return channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel subscribe(int connectionId, int tunnelChannelId) throws NoChannelsAvailableException {
        Channel selectedChannel = null;
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel channel : this.tunnelChannels) {
                if (ConnectionId.get(channel) != tunnelChannelId) continue;
                selectedChannel = channel;
                break;
            }
        }
        if (selectedChannel == null) {
            throw new NoChannelsAvailableException("Unable to find tunnel channel with id: " + ChannelUtil.formatConnectionId((int)tunnelChannelId));
        }
        if (this.channelSubscriptions.containsKey(connectionId)) {
            throw new IllegalStateException("Channel already subscribed");
        }
        this.channelSubscriptions.put(connectionId, selectedChannel);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Subscribed connection with id: {0} to tunnel channel {1}", ChannelUtil.formatConnectionId((int)connectionId), selectedChannel));
        }
        return selectedChannel;
    }

    public void unsubscribe(int connectionId) {
        this.channelSubscriptions.remove(connectionId);
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("Unsubscribed connection with id: {0}", ChannelUtil.formatConnectionId((int)connectionId)));
        }
    }

    public Channel getSubscribedChannel(int connectionId) {
        return this.channelSubscriptions.get(connectionId);
    }

    public ChannelFuture writeToSubscribedChannel(int connectionId, MessagePacket message) {
        Channel channel = this.channelSubscriptions.get(connectionId);
        if (channel == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Discarding package as there is no subscribed channel for connection id: " + ChannelUtil.formatConnectionId((int)connectionId)));
            }
            assert (AssertionUtil.propagateException((Throwable)new IllegalStateException("Discarding package as there is no subscribed channel for connectionId: " + ChannelUtil.formatConnectionId((int)connectionId))));
            return null;
        }
        return this.writeToChannel(channel, message);
    }

    public ChannelFuture write(MessagePacket message) throws NoChannelsAvailableException {
        if (this.tunnelChannels.size() == 0) {
            throw new NoChannelsAvailableException();
        }
        return this.writeToChannel(this.tunnelChannels.get(0), message);
    }

    public TunnelRequestFuture writeRequest(MessagePacket request) throws NoChannelsAvailableException {
        if (this.tunnelChannels.size() == 0) {
            throw new NoChannelsAvailableException();
        }
        return this.writeRequest(this.tunnelChannels.get(0), request);
    }

    public TunnelRequestFuture writeRequest(Channel channel, MessagePacket request) {
        String requestIdString = request.getProperty("requestId");
        if (requestIdString == null) {
            throw new IllegalArgumentException("No request id found in request packet");
        }
        ChannelFuture tunnelWriteFuture = this.writeToChannel(channel, request);
        int requestId = Integer.parseInt(requestIdString);
        TunnelRequestFuture requestFuture = new TunnelRequestFuture(tunnelWriteFuture, this.tunnelId, requestId);
        requestFuture.addListener((GenericFutureListener)new GenericFutureListener<TunnelRequestFuture>(){

            public void operationComplete(TunnelRequestFuture future) throws Exception {
                Tunnel.this.requestFutures.remove(future.requestId());
            }
        });
        this.requestFutures.put(requestId, requestFuture);
        return requestFuture;
    }

    public TunnelRequestFuture writeRequest(Channel channel, MessagePacket request, long timeout, TimeUnit unit) {
        TunnelRequestFuture requestFuture = this.writeRequest(channel, request);
        FutureTimeout<TunnelRequestFuture> requestFutureTimeout = new FutureTimeout<TunnelRequestFuture>(requestFuture, timeout, unit);
        requestFutureTimeout.addListener(new FutureTimeoutListener<TunnelRequestFuture>(){

            @Override
            public void operationTimedOut(TunnelRequestFuture tunnelRequestFuture, long timeoutNanos) {
                String timeoutMessage = MessageFormat.format("Tunnel request through tunnel with id {0} timed out after {1} milliseconds", tunnelRequestFuture.tunnelId(), TimeUnit.NANOSECONDS.toMillis(timeoutNanos));
                tunnelRequestFuture.tryFailure(new TimeoutException(timeoutMessage));
            }
        });
        return requestFuture;
    }

    public TunnelRequestFuture sendRequest(int connectionId, MessagePacket request, long timeout, TimeUnit unit) throws NoChannelsAvailableException {
        Channel channel = this.getSubscribedChannel(connectionId);
        if (channel == null) {
            throw new NoChannelsAvailableException("No channel subscribed to connection with id " + connectionId);
        }
        return this.writeRequest(channel, request, timeout, unit);
    }

    public void responseReceived(int responseId, MessagePacket response) {
        TunnelRequestFuture future = this.requestFutures.get(responseId);
        if (future == null || !future.trySucess(response)) {
            log.debug((Object)("Discarding synchronous response with id '" + responseId + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(MessagePacket message) {
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel channel : this.tunnelChannels) {
                this.writeToChannel(channel, message);
            }
        }
    }

    public void dispose() {
        this.tracingConfiguration.removeListener((TracingConfigurationChangeListener)this.configurationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Channel> getChannels() {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel tc : this.tunnelChannels) {
                channels.add(tc);
            }
        }
        return Collections.unmodifiableList(channels);
    }

    public boolean containsChannel(Channel channel) {
        return this.tunnelChannels.contains(channel);
    }

    public String getClientId() {
        return this.clientId;
    }

    public Date getCreationDate() {
        Date creationDate = new Date();
        for (Date channelCreationDate : this.creationDates.values()) {
            if (!channelCreationDate.before(creationDate)) continue;
            creationDate = channelCreationDate;
        }
        return creationDate;
    }

    public SCCVersion getMasterAgentVersion() {
        return this.masterVersion;
    }

    public SCCVersion getShadowAgentVersion() {
        return this.shadowVersion;
    }

    public void handleOpenTunnelHeader(String name, String value) {
        try {
            if ("masterVersion".equals(name)) {
                this.masterVersion = new SCCVersion(value);
            } else if ("shadowVersion".equals(name)) {
                this.shadowVersion = new SCCVersion(value);
            }
        }
        catch (IllegalArgumentException iae) {
            log.error((Object)"Failed to parse SCC version header", (Throwable)iae);
        }
    }

    private ChannelFuture writeToChannel(Channel channel, final MessagePacket message) {
        boolean traceEnabled = log.isTraceEnabled();
        final boolean isPayload = message instanceof PayloadMessagePacket;
        if (traceEnabled) {
            if (isPayload) {
                PayloadMessagePacket payloadPacket = (PayloadMessagePacket)message;
                log.trace((Object)MessageFormat.format("Will send message of type {0} with size {1} over tunnel channel {2}. Tunnel id: \"{3}\"", payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), channel, this.tunnelId));
            } else {
                log.trace((Object)MessageFormat.format("Will send message of type {0} over tunnel channel {1}. Tunnel id: \"{2}\"", message.getType(), channel, this.tunnelId));
            }
        }
        ReferenceCountUtil.retain((Object)message);
        ChannelFuture writeAndFlushFuture = channel.writeAndFlush((Object)message);
        if (traceEnabled) {
            writeAndFlushFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel futureChannel = future.channel();
                    if (future.isSuccess()) {
                        if (isPayload) {
                            PayloadMessagePacket payloadPacket = (PayloadMessagePacket)message;
                            log.trace((Object)MessageFormat.format("Sent message of type {0} with payload size {1} over tunnel channel {2}. Tunnel id: \"{3}\"", payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), futureChannel, Tunnel.this.tunnelId));
                        } else {
                            log.trace((Object)MessageFormat.format("Sent message of type {0} over tunnel channel {1}. Tunnel id: \"{2}\"", message.getType(), futureChannel, Tunnel.this.tunnelId));
                        }
                    } else {
                        Object cause = future.cause() != null ? future.cause() : "not available";
                        String failureReason = "FAILED";
                        if (future.isCancelled()) {
                            failureReason = "CANCELED";
                        }
                        if (isPayload) {
                            PayloadMessagePacket payloadPacket = (PayloadMessagePacket)message;
                            log.error((Object)MessageFormat.format("Write operation {0} for message of type {1} with payload size {2} over tunnel channel {3}. Tunnel id: \"{4}\". Cause: {5}", failureReason, payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), Tunnel.this.tunnelId, futureChannel, cause));
                        } else {
                            log.error((Object)MessageFormat.format("Write operation {0} for message of type {1} over tunnel channel {2}. Tunnel id: \"{3}\". Cause: {4}", failureReason, message.getType(), futureChannel, Tunnel.this.tunnelId, cause));
                        }
                    }
                }
            });
        }
        return writeAndFlushFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableTracing() {
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel channel : this.tunnelChannels) {
                this.enableTracing(channel);
            }
        }
    }

    private void enableTracing(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.fireUserEventTriggered((Object)new PayloadTracerEvent(PayloadTracerEvent.Action.ENABLE, this.tunnelId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableTracing() {
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel channel : this.tunnelChannels) {
                this.disableTracing(channel);
            }
        }
    }

    private void disableTracing(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.fireUserEventTriggered((Object)new PayloadTracerEvent(PayloadTracerEvent.Action.DISABLE));
    }

    @Override
    public int compareTo(Tunnel other) {
        return this.tunnelId.compareTo(other.tunnelId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Tunnel [");
        sb.append(String.format(" objectID [%s]", super.toString()));
        sb.append(String.format("; clientID [%s]", this.clientId));
        sb.append(String.format("; tunnelID [%s]", this.tunnelId));
        sb.append(String.format("; currentChannel [%s]", this.currentChannel));
        sb.append(String.format("; tunnelChannels [%s]", this.tunnelChannels));
        sb.append(String.format("; channelSubscriptions [%s]", this.channelSubscriptions));
        sb.append(" ]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        List<Channel> list = this.tunnelChannels;
        synchronized (list) {
            for (Channel channel : this.tunnelChannels) {
                ChannelUtil.close((Channel)channel);
            }
        }
    }

    private class TraceConfigurationChangeListener
    implements TracingConfigurationChangeListener {
        private TraceConfigurationChangeListener() {
        }

        public void configurationChanged(TracingConfigurationChangeEvent event) {
            if (event.getTunnelId() == null || Tunnel.this.tunnelId.equals(event.getTunnelId())) {
                if (Tunnel.this.tracingConfiguration.isTracingEnabled(Tunnel.this.tunnelId)) {
                    Tunnel.this.enableTracing();
                } else {
                    Tunnel.this.disableTracing();
                }
            }
        }
    }
}

