/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public class TunnelConnection
implements AutoCloseable {
    private final int connectionId;
    private final Tunnel tunnel;

    public TunnelConnection(int connectionId, Tunnel tunnel) {
        this.connectionId = connectionId;
        this.tunnel = tunnel;
    }

    public void open() throws NoChannelsAvailableException {
        this.tunnel.subscribe(this.connectionId);
    }

    public int connectionId() {
        return this.connectionId;
    }

    public String tunnelId() {
        return this.tunnel.getId();
    }

    public TunnelRequestFuture sendRequest(MessagePacket request, long timeout, TimeUnit unit) throws NoChannelsAvailableException {
        if (!this.isValidRequest(request)) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid request received {0}", request));
        }
        return this.tunnel.sendRequest(this.connectionId, request, timeout, unit);
    }

    private boolean isValidRequest(MessagePacket request) {
        return this.tunnelId().equals(request.getProperty("tunnelId"));
    }

    @Override
    public void close() {
        this.tunnel.unsubscribe(this.connectionId);
    }
}

