/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core;

import com.sap.core.connectivity.spi.protocol.MessagePacket;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;

public class TunnelRequestFuture
extends DefaultChannelPromise {
    private final String tunnelId;
    private final int requestId;
    private MessagePacket response;

    TunnelRequestFuture(ChannelFuture tunnelWriteFuture, String tunnelId, int requestId) {
        super(tunnelWriteFuture.channel());
        this.tunnelId = tunnelId;
        this.requestId = requestId;
        tunnelWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    TunnelRequestFuture.this.tryFailure(future.cause());
                }
            }
        });
        this.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                TunnelRequestFuture.this.tryFailure(new ClosedChannelException());
            }
        });
    }

    public String tunnelId() {
        return this.tunnelId;
    }

    public int requestId() {
        return this.requestId;
    }

    public MessagePacket response() {
        return this.response;
    }

    boolean trySucess(MessagePacket response) {
        this.response = response;
        boolean trySuccess = this.trySuccess();
        if (!trySuccess) {
            this.response = null;
        }
        return trySuccess;
    }
}

