/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.connection;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.NoTunnelsSubscribedException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.core.TunnelConnection;
import com.sap.core.connectivity.tunnel.core.TunnelRequestFuture;
import com.sap.core.connectivity.tunnel.core.connection.ClientRequest;
import com.sap.core.connectivity.tunnel.core.context.InboundConnection;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ClientConnection
implements InboundConnection,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(ClientConnection.class);
    private final Channel clientChannel;
    private final ConnectionProtocol clientProtocol;
    private final Set<TunnelConnection> tunnelConnections;

    public ClientConnection(Channel clientChannel, ConnectionProtocol clientProtocol, Set<TunnelConnection> tunnelConnections) {
        this.clientChannel = clientChannel;
        this.clientProtocol = clientProtocol;
        this.tunnelConnections = new HashSet<TunnelConnection>(tunnelConnections);
    }

    public void open() throws NoTunnelsSubscribedException {
        Iterator<TunnelConnection> tunnelConnectionIterator = this.tunnelConnections.iterator();
        while (tunnelConnectionIterator.hasNext()) {
            TunnelConnection tunnelConnection = tunnelConnectionIterator.next();
            try {
                tunnelConnection.open();
            }
            catch (NoChannelsAvailableException e) {
                logger.info((Object)MessageFormat.format("Tunnel with tunnelId {0} was closed in meantime", tunnelConnection.tunnelId()));
                tunnelConnectionIterator.remove();
            }
        }
        if (this.tunnelConnections.isEmpty()) {
            throw new NoTunnelsSubscribedException();
        }
    }

    public <ResponseType> void requestReceived(ClientRequest<ResponseType> clientRequest) throws NoTunnelsSubscribedException {
        ArrayList<TunnelRequestFuture> requestFutures = new ArrayList<TunnelRequestFuture>(this.tunnelConnections.size());
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            try {
                String tunnelId = tunnelConnection.tunnelId();
                MessagePacket requestPacket = clientRequest.createTunnelRequest(tunnelId);
                TunnelRequestFuture requestFuture = tunnelConnection.sendRequest(requestPacket, clientRequest.getTimeoutMillis(), TimeUnit.MILLISECONDS);
                requestFutures.add(requestFuture);
            }
            catch (NoChannelsAvailableException e) {
                logger.info((Object)MessageFormat.format("Client request cannot be sent through tunnel with tunnelId {0}", tunnelConnection.tunnelId()), (Throwable)e);
            }
        }
        if (requestFutures.isEmpty()) {
            throw new NoTunnelsSubscribedException();
        }
        this.addListeners(clientRequest, requestFutures);
    }

    private <ResponseType> void addListeners(final ClientRequest<ResponseType> clientRequest, final List<TunnelRequestFuture> requestFutures) {
        final ArrayList responses = new ArrayList(requestFutures.size());
        for (TunnelRequestFuture requestFuture : requestFutures) {
            requestFuture.addListener((GenericFutureListener)new GenericFutureListener<TunnelRequestFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(TunnelRequestFuture future) throws Exception {
                    Object response = future.isSuccess() ? clientRequest.createClientResponse(future.tunnelId(), future.response()) : clientRequest.createClientResponse(future.tunnelId(), future.cause());
                    List list = responses;
                    synchronized (list) {
                        responses.add(response);
                        if (responses.size() == requestFutures.size()) {
                            Object aggregatedResponse = clientRequest.aggregateClientResponses(responses);
                            ClientConnection.this.clientChannel.writeAndFlush(aggregatedResponse).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void close() {
        for (TunnelConnection tunnelConnection : this.tunnelConnections) {
            tunnelConnection.close();
        }
    }

    @Override
    public Channel channel() {
        return this.clientChannel;
    }

    @Override
    public ConnectionProtocol getProtocol() {
        return this.clientProtocol;
    }
}

