/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.context;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.InboundConnectionRegistry;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import com.sap.core.connectivity.tunnel.core.context.SystemMessagePacketFactory;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import com.sap.core.connectivity.tunnel.core.impl.context.InboundConnectionRegistryImpl;
import com.sap.core.connectivity.tunnel.core.impl.context.ProcessingContextImpl;
import com.sap.core.connectivity.tunnel.core.impl.context.ServiceRegistryImpl;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelBridge;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryImpl;
import com.sap.core.connectivity.tunnel.core.impl.processing.InboundPacketProcessor;
import com.sap.core.connectivity.tunnel.core.impl.processing.OutboundPacketProcessor;
import com.sap.core.connectivity.tunnel.core.impl.processing.ResponsePacketProcessor;
import com.sap.core.connectivity.tunnel.core.impl.processing.TunnelSubscribingProcessor;
import com.sap.core.connectivity.tunnel.core.impl.protocol.MessagePacketFactoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DefaultConnectivityContext
implements ConnectivityContext {
    private static long processStartTime;
    protected final ServiceRegistry serviceRegistry;
    protected final InboundConnectionRegistry connectionRegistry;
    protected final TunnelRegistry tunnelRegistry;
    protected final SystemMessagePacketFactory messagePacketFactory = new MessagePacketFactoryImpl();
    protected final Map<Integer, MessagePacketProcessor> messagePacketProcessors = new TreeMap<Integer, MessagePacketProcessor>();

    public DefaultConnectivityContext() {
        this(new ServiceRegistryImpl());
    }

    public DefaultConnectivityContext(ServiceRegistry serviceRegistry) {
        processStartTime = System.currentTimeMillis();
        this.serviceRegistry = serviceRegistry;
        this.tunnelRegistry = new TunnelRegistryImpl(this);
        this.connectionRegistry = new InboundConnectionRegistryImpl(this.tunnelRegistry);
        this.initializeDefaultPacketProcessors();
    }

    protected void initializeDefaultPacketProcessors() {
        this.messagePacketProcessors.put(10, new InboundPacketProcessor(this));
        this.messagePacketProcessors.put(11, new TunnelSubscribingProcessor(this));
        this.messagePacketProcessors.put(20, new OutboundPacketProcessor(this));
        this.messagePacketProcessors.put(100, new ResponsePacketProcessor(this));
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public InboundConnectionRegistry getInboundConnectionRegistry() {
        return this.connectionRegistry;
    }

    @Override
    public TunnelRegistry getTunnelRegistry() {
        return this.tunnelRegistry;
    }

    @Override
    public SystemMessagePacketFactory getMessagePacketFactory() {
        return this.messagePacketFactory;
    }

    @Override
    public void registerMessagePacketProcessor(int priority, MessagePacketProcessor processor) {
        if (this.messagePacketProcessors.containsKey(priority)) {
            throw new IllegalStateException("Message packet processor with priority " + priority + " has already been registered");
        }
        this.messagePacketProcessors.put(priority, processor);
    }

    @Override
    public void unregisterMessagePacketProcessor(int priority) {
        this.messagePacketProcessors.remove(priority);
    }

    @Override
    public List<MessagePacketProcessor> getMessagePacketProcessors() {
        return new ArrayList<MessagePacketProcessor>(this.messagePacketProcessors.values());
    }

    @Override
    public ProcessingContext createProcessingContext(String tunnelId) {
        TunnelBridge tunnel = new TunnelBridge(tunnelId, this.tunnelRegistry);
        return new ProcessingContextImpl(tunnel, this.messagePacketFactory, this.serviceRegistry);
    }

    @Override
    public long getProcessStartTimeMillis() {
        return processStartTime;
    }
}

