/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ErrorHandler;
import com.sap.core.connectivity.spi.TunnelException;
import com.sap.core.connectivity.spi.extension.ExtensionRegistry;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelProvidedServices;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.InboundConnection;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public abstract class AbstractErrorHandler
extends ChannelInboundHandlerAdapter {
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private final ConnectivityContext connectivityContext;
    private final ExtensionRegistry extensionRegistry;

    public AbstractErrorHandler(ConnectivityContext connectivityContext) {
        this.connectivityContext = connectivityContext;
        this.extensionRegistry = (ExtensionRegistry)TunnelProvidedServices.getService(ExtensionRegistry.class);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (cause instanceof IOException) {
            this.log.error((Object)MessageFormat.format("Input/output exception in {0}: {1}", this.getServiceName(), cause));
            ChannelUtil.close((Channel)channel);
            return;
        }
        try {
            this.handleError(cause, channel);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception caught while handling an exception, closing channel to " + this.getServiceName()), (Throwable)e);
            ChannelUtil.close((Channel)channel);
        }
    }

    protected abstract String getServiceName();

    protected void handleError(Throwable error, Channel channel) {
        if (error instanceof WriteTimeoutException) {
            if (this.log.isDebugEnabled()) {
                WriteTimeoutException cause = (WriteTimeoutException)error;
                this.log.debug((Object)MessageFormat.format("Received write timeout exception on channel which shall be closed by the WriteTimeoutHandler {0}", channel), (Throwable)cause);
            }
            return;
        }
        this.log.error((Object)("Exception in " + this.getServiceName()), error);
        if (channel.isOpen()) {
            ConnectionProtocol protocol = this.getConnectionProtocol(channel);
            ErrorHandler errorHandler = this.extensionRegistry.getErrorHandler(protocol);
            if (error instanceof TunnelException) {
                TunnelException tunnelException = (TunnelException)error;
                errorHandler.handleError(channel, tunnelException.getErrorCode(), tunnelException.getMessage());
            } else {
                errorHandler.handleError(channel, 100, error.getMessage());
            }
        }
    }

    private ConnectionProtocol getConnectionProtocol(Channel channel) {
        InboundConnection connection = this.connectivityContext.getInboundConnectionRegistry().getConnection(ConnectionId.get(channel));
        if (connection != null) {
            return connection.getProtocol();
        }
        return null;
    }
}

