/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.logging.LoggingContext;
import com.sap.core.connectivity.spi.processing.flow.DemandReadEvent;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import com.sap.core.connectivity.tunnel.core.handshake.TunnelHandshakeCompletionEvent;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.flow.FlowControlHandler;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;

public class MessagePacketHandler
extends SimpleChannelInboundHandler<MessagePacket> {
    private static final String FLOW_CONTROL_HANDLER_NAME = "flowControlHandler";
    private static final Logger log = Logger.getLogger(MessagePacketHandler.class);
    private final ConnectivityContext connectivityContext;
    private final boolean isMemorySafeMode;
    private final List<MessagePacketProcessor> processors;
    private ProcessingContext processingContext;
    private boolean isChannelReadComplete;

    public MessagePacketHandler(ConnectivityContext connectivityContext) {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)connectivityContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.isMemorySafeMode = tunnelConfiguration.getServerMemorySafeMode();
        this.connectivityContext = connectivityContext;
        this.processors = connectivityContext.getMessagePacketProcessors();
    }

    public MessagePacketHandler(String tunnelId, ConnectivityContext connectivityContext) {
        this(tunnelId, connectivityContext, connectivityContext.getMessagePacketProcessors());
    }

    public MessagePacketHandler(String tunnelId, ConnectivityContext connectivityContext, List<MessagePacketProcessor> processors) {
        this.connectivityContext = connectivityContext;
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)connectivityContext.getServiceRegistry().getService(TunnelConfiguration.class);
        this.isMemorySafeMode = tunnelConfiguration.getServerMemorySafeMode();
        this.processors = processors;
        this.processingContext = connectivityContext.createProcessingContext(tunnelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, MessagePacket packet) throws Exception {
        this.isChannelReadComplete = false;
        LoggingContext.putConnectionId((int)packet.getConnectionId());
        this.logTraceMessageReceived(ctx, packet);
        try {
            this.invokeProcessors(packet, ctx.channel());
        }
        catch (Exception e) {
            log.error((Object)"Internal error", (Throwable)e);
            ctx.fireExceptionCaught((Throwable)e);
        }
        finally {
            LoggingContext.removeConnectionId();
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().addBefore(ctx.name(), FLOW_CONTROL_HANDLER_NAME, (ChannelHandler)new FlowControlHandler());
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.isMemorySafeMode) {
            ctx.pipeline().remove(FLOW_CONTROL_HANDLER_NAME);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof TunnelHandshakeCompletionEvent) {
            TunnelHandshakeCompletionEvent handshakeCompleteEvent = (TunnelHandshakeCompletionEvent)evt;
            this.processingContext = this.connectivityContext.createProcessingContext(handshakeCompleteEvent.getTunnelId());
            return;
        }
        if (evt instanceof DemandReadEvent) {
            if (this.isChannelReadComplete && ctx.channel().config().isAutoRead()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"userEventTriggered -> triggering ctx.read()");
                }
                ctx.read();
            }
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isChannelReadComplete = true;
        super.channelReadComplete(ctx);
    }

    private void invokeProcessors(MessagePacket packet, Channel channel) {
        for (MessagePacketProcessor processor : this.processors) {
            boolean shouldContinueProcessing;
            if (!processor.acceptsPacket(packet) || (shouldContinueProcessing = processor.processPacket(packet, channel, this.processingContext))) continue;
            return;
        }
    }

    private void logTraceMessageReceived(ChannelHandlerContext ctx, MessagePacket packet) {
        if (log.isTraceEnabled()) {
            Channel channel = ctx.channel();
            String tunnelIdInfo = "Tunnel id not yet available!";
            if (this.processingContext != null) {
                tunnelIdInfo = MessageFormat.format(" Tunnel id: \"{0}\"", this.processingContext.getTunnel().getId());
            }
            if (packet instanceof PayloadMessagePacket) {
                PayloadMessagePacket payloadPacket = (PayloadMessagePacket)packet;
                log.trace((Object)MessageFormat.format("Received message of type {0} with size {1} over tunnel channel {2}.{3}", payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), channel, tunnelIdInfo));
            } else {
                log.trace((Object)MessageFormat.format("Received message of type {0} over tunnel channel {1}.{2}", packet.getType(), channel, tunnelIdInfo));
            }
        }
    }
}

