/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.core.handlers.TunnelErrorHandler;
import com.sap.core.connectivity.tunnel.core.impl.context.PayloadTracerEvent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class PayloadTracer
extends ChannelDuplexHandler {
    private static final int LINE_BUF_SIZE = 115;
    private static final Charset cs = Charset.forName("ISO-8859-1");
    private static final byte[] NL = System.getProperty("line.separator").getBytes(cs);
    private Logger trace;
    private final SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS Z");
    private boolean isPayloadTraceEnabled = false;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.isPayloadTraceEnabled) {
            this.dumpBuffer(msg, "Request data");
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.isPayloadTraceEnabled) {
            this.dumpBuffer(msg, "Response data");
        }
        ctx.writeAndFlush(msg, promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof PayloadTracerEvent) {
            this.handlePayloadTraceEvent((PayloadTracerEvent)evt);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    private void handlePayloadTraceEvent(PayloadTracerEvent event) {
        PayloadTracerEvent.Action operation = event.getOperation();
        boolean bl = this.isPayloadTraceEnabled = operation == PayloadTracerEvent.Action.ENABLE;
        if (this.isPayloadTraceEnabled) {
            this.trace = Logger.getLogger((String)("tracing.payload." + event.getAccount()));
        }
    }

    private void dumpBuffer(Object message, String type) {
        if (!(message instanceof PayloadMessagePacket)) {
            return;
        }
        PayloadMessagePacket packet = (PayloadMessagePacket)message;
        ByteBuf payload = packet.getPayload();
        int dataLen = payload.readableBytes();
        Dumpbuffer buffer = new Dumpbuffer(ChannelUtil.formatConnectionId((int)packet.getConnectionId()), type);
        payload.markReaderIndex();
        byte[] lineBuf = new byte[115];
        lineBuf[80] = 32;
        lineBuf[71] = 32;
        lineBuf[62] = 32;
        lineBuf[53] = 32;
        lineBuf[44] = 32;
        lineBuf[35] = 32;
        lineBuf[26] = 32;
        lineBuf[17] = 32;
        lineBuf[8] = 32;
        lineBuf[6] = 32;
        lineBuf[114] = 124;
        lineBuf[81] = 124;
        lineBuf[7] = 124;
        for (int i = 0; i < dataLen; i += 32) {
            PayloadTracer.convertToChar(i, lineBuf, 0, 6);
            int pos = 9;
            int j = 0;
            while (j < 32) {
                if (i + j < dataLen) {
                    int value = payload.readByte();
                    if (value < 0) {
                        value += 256;
                    }
                    PayloadTracer.convertToChar(value, lineBuf, pos, 2);
                    lineBuf[82 + j] = (byte)(Character.isISOControl(value) ? 46 : value);
                } else {
                    lineBuf[82 + j] = 32;
                    lineBuf[pos + 1] = 32;
                    lineBuf[pos] = 32;
                }
                pos += ++j % 4 == 0 ? 3 : 2;
            }
            buffer.trace(lineBuf);
            buffer.trace(PayloadTracer.NL);
        }
        buffer.flush();
        payload.resetReaderIndex();
    }

    private static void convertToChar(int value, byte[] result, int offset, int digits) {
        int i = digits + offset - 1;
        int m = 16;
        while (i >= offset) {
            result[i] = (byte)((value - value / m * m) / (m / 16) + 48);
            if (result[i] > 57) {
                int n = i;
                result[n] = (byte)(result[n] + 7);
            }
            --i;
            m *= 16;
        }
    }

    private class Dumpbuffer {
        private ByteArrayOutputStream buffer;
        private String connectionID;
        private String requestType;

        private Dumpbuffer(String connID, String type) {
            this.connectionID = connID;
            this.requestType = type;
            this.buffer = new ByteArrayOutputStream(30000);
        }

        private void trace(byte[] data) {
            try {
                this.buffer.write(data);
                if (this.buffer.size() >= 28000) {
                    this.flush();
                }
            }
            catch (IOException e) {
                Logger.getLogger(TunnelErrorHandler.class).error((Object)"IO Error while tracing payload", (Throwable)e);
            }
        }

        private void flush() {
            StringBuilder temp = new StringBuilder(this.buffer.size() + 1000);
            temp.append(">>> ");
            temp.append(PayloadTracer.this.myFormatter.format(new Date()));
            temp.append("  >>> ").append(this.requestType).append(" for connection ").append(this.connectionID).append(" in thread ").append(Thread.currentThread().getName()).append('\n');
            byte[] dataToTrace = this.buffer.toByteArray();
            temp.append(new String(dataToTrace, cs));
            temp.append("\n<<< ").append(this.requestType);
            PayloadTracer.this.trace.trace((Object)temp.toString());
            this.buffer.reset();
        }
    }
}

