/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.util.AssertionUtil;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import com.sap.core.connectivity.tunnel.core.util.WhitelistedObjectInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TunnelProtocolDecoder
extends MessageToMessageDecoder<BinaryWebSocketFrame> {
    private static Set<String> DESERIALIZATION_WHITELIST = new HashSet<String>();
    private final ConnectivityContext context;

    public TunnelProtocolDecoder(ConnectivityContext context) {
        this.context = context;
    }

    protected void decode(ChannelHandlerContext ctx, BinaryWebSocketFrame msg, List<Object> out) throws Exception {
        MessagePacket msgPacket = this.deserialize(msg.content(), ctx.channel());
        out.add(msgPacket);
    }

    private MessagePacket deserialize(ByteBuf binaryData, Channel channel) throws Exception {
        MessagePacket messagePacket;
        int payloadLength;
        String owner;
        byte ownerLength = binaryData.readByte();
        if (ownerLength == 0) {
            owner = "system";
        } else {
            byte[] ownerBuffer = new byte[ownerLength];
            binaryData.readBytes(ownerBuffer);
            owner = new String(ownerBuffer, Charset.forName("UTF-8"));
        }
        byte type = binaryData.readByte();
        int connectionId = binaryData.readInt();
        Properties properties = new Properties();
        int propertiesLength = binaryData.readInt();
        if (propertiesLength > -1) {
            byte[] propertiesBuffer = new byte[propertiesLength];
            binaryData.readBytes(propertiesBuffer);
            properties = this.deserializeProperties(propertiesBuffer);
        }
        if ((payloadLength = binaryData.readInt()) > -1) {
            ByteBuf payload = binaryData.slice().retain();
            messagePacket = this.context.getMessagePacketFactory().createPayloadPacket(owner, type, connectionId, payload);
        } else {
            messagePacket = this.context.getMessagePacketFactory().createMessagePacket(owner, type, connectionId);
        }
        for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
            messagePacket.setProperty((String)propertyEntry.getKey(), (String)propertyEntry.getValue());
        }
        Integer channelId = ConnectionId.get(channel);
        messagePacket.setProperty("tunnelChannelId", Integer.toString(channelId));
        return messagePacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties deserializeProperties(byte[] propertiesBuffer) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(propertiesBuffer);
        try {
            WhitelistedObjectInputStream objectInputStream = new WhitelistedObjectInputStream(byteArrayInputStream, DESERIALIZATION_WHITELIST);
            Properties properties = (Properties)objectInputStream.readObject();
            return properties;
        }
        finally {
            block7: {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled || AssertionUtil.propagateException((Throwable)e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    static {
        DESERIALIZATION_WHITELIST.add(Properties.class.getName());
        DESERIALIZATION_WHITELIST.add(Hashtable.class.getName());
    }
}

