/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.tunnel.core.impl.protocol.MessagePacketImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TunnelProtocolEncoder
extends MessageToMessageEncoder<MessagePacket> {
    private static final Logger log = Logger.getLogger(TunnelProtocolEncoder.class);

    protected void encode(ChannelHandlerContext ctx, MessagePacket packet, List<Object> out) throws Exception {
        ByteBuf byteBuf = this.serialize(ctx, packet);
        out.add(new BinaryWebSocketFrame(byteBuf));
    }

    private ByteBuf serialize(ChannelHandlerContext ctx, MessagePacket packet) throws Exception {
        ByteBuf buffer = ctx.alloc().buffer();
        if ("system".equals(packet.getOwner())) {
            buffer.writeByte(0);
        } else {
            byte[] ownerByteBuffer = packet.getOwner().getBytes(Charset.forName("UTF-8"));
            buffer.writeByte(ownerByteBuffer.length);
            buffer.writeBytes(ownerByteBuffer);
        }
        buffer.writeByte(packet.getType());
        buffer.writeInt(packet.getConnectionId());
        Properties properties = ((MessagePacketImpl)packet).getProperties();
        if (properties != null) {
            byte[] propertiesBuffer = this.serializeProperties(properties);
            buffer.writeInt(propertiesBuffer.length);
            buffer.writeBytes(propertiesBuffer);
        } else {
            buffer.writeInt(-1);
        }
        if (packet instanceof PayloadMessagePacket) {
            ByteBuf payload = ((PayloadMessagePacket)packet).getPayload();
            payload.retain();
            buffer.writeInt(payload.readableBytes());
            buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, payload});
        } else {
            buffer.writeInt(-1);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeProperties(Properties properties) throws Exception {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayStream);
            objectOutputStream.writeObject(properties);
            byte[] byArray = byteArrayStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayStream.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }
}

