/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.handlers;

import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.processing.DefaultErrorHandlingListener;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TunnelStateHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger log = Logger.getLogger(TunnelStateHandler.class);
    private static final String IDLE_HANDLER_NAME = "idleStateHandler";
    private final AtomicInteger failedPingsCounter = new AtomicInteger();
    private final String tunnelId;
    private final TunnelConfiguration configuration = (TunnelConfiguration)TunnelConsumableServices.getService(TunnelConfiguration.class);
    private final int idleAllTime;
    private final boolean isClientSide;

    public TunnelStateHandler(String tunnelId, boolean isClientSide) {
        this.tunnelId = tunnelId;
        this.idleAllTime = this.configuration.getIdleTime();
        this.isClientSide = isClientSide;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), IDLE_HANDLER_NAME, (ChannelHandler)new IdleStateHandler(0, this.idleWriteTime(), this.idleAllTime));
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().remove(IDLE_HANDLER_NAME);
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof PingWebSocketFrame || msg instanceof PongWebSocketFrame;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.handleIdleStateEvent(ctx, (IdleStateEvent)evt);
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        if (msg instanceof PongWebSocketFrame) {
            this.readPong();
        } else if (msg instanceof PingWebSocketFrame) {
            this.readPing(ctx.channel());
        } else {
            throw new IllegalStateException("Tunnel state handler received unexpected WebSocetFrame of type: " + msg.getClass());
        }
    }

    private void handleIdleStateEvent(ChannelHandlerContext ctx, IdleStateEvent evt) {
        Channel channel = ctx.channel();
        if (evt.state() == IdleState.ALL_IDLE && this.isClientSide) {
            if (this.isMaxFailedPingsReached(channel)) {
                this.closeChannel(channel);
            } else {
                this.sendPing(channel);
            }
        } else if (evt.state() == IdleState.WRITER_IDLE) {
            this.sendPong(channel);
        }
    }

    private void closeChannel(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing channel with id " + ChannelUtil.formatConnectionId((int)ConnectionId.get(channel)) + ", after " + this.configuration.getMaxFailedPingAttempts() + " failed ping requests"));
        }
        ChannelUtil.close((Channel)channel);
    }

    private int idleWriteTime() {
        int deviationTimeSeconds = Math.round((float)this.idleAllTime * 0.2f);
        return this.idleAllTime + deviationTimeSeconds;
    }

    private boolean isMaxFailedPingsReached(Channel channel) {
        int currentNumberOfFailedPings = this.failedPingsCounter.incrementAndGet();
        return currentNumberOfFailedPings > this.configuration.getMaxFailedPingAttempts() && channel.isActive();
    }

    private void sendPing(Channel channel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Sending ping for tunnel with ID \"{0}\" for tunnel channel {1}", this.tunnelId, channel));
        }
        channel.writeAndFlush((Object)new PingWebSocketFrame()).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
    }

    private void sendPong(Channel channel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Sending pong for tunnel with id \"{0}\" Tunnel channel: {1}", this.tunnelId, channel));
        }
        channel.writeAndFlush((Object)new PongWebSocketFrame()).addListener((GenericFutureListener)DefaultErrorHandlingListener.INSTANCE);
    }

    private void readPong() {
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Received pong for tunnel \"{0}\"", this.tunnelId));
        }
        this.failedPingsCounter.set(0);
    }

    private void readPing(Channel channel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Received ping for tunnel with id \"{0}\" Tunnel channel: {1}", this.tunnelId, channel));
        }
        this.sendPong(channel);
    }
}

