/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;

public class HttpResponseFactory {
    public static FullHttpResponse createResponse(HttpResponseStatus status) {
        return HttpResponseFactory.createResponse(status, null);
    }

    public static FullHttpResponse createResponse(HttpResponseStatus status, String content) {
        return HttpResponseFactory.createResponse(status, content, true);
    }

    public static FullHttpResponse createResponse(HttpResponseStatus status, String content, boolean closeConnection) {
        return HttpResponseFactory.createResponse(status, content, closeConnection, "text/plain; charset=utf-8");
    }

    public static FullHttpResponse createResponse(HttpResponseStatus status, String content, boolean closeConnection, String contentType) {
        DefaultFullHttpResponse response = null;
        if (content != null) {
            ByteBuf contentBuffer = Unpooled.wrappedBuffer((byte[])content.getBytes(Charset.forName("UTF-8")));
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, contentBuffer);
            response.headers().set("Content-Type", (Object)contentType);
            response.headers().set("Content-Length", (Object)contentBuffer.readableBytes());
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().set("Content-Length", (Object)0);
        }
        if (closeConnection) {
            response.headers().set("Connection", (Object)"close");
        }
        return response;
    }
}

