/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractScheduledExecutionService {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ScheduledExecutorService scheduledExecutionService;

    public final void start(int executionPeriod, TimeUnit timeUnit) {
        this.scheduledExecutionService = Executors.newScheduledThreadPool(1);
        this.scheduledExecutionService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AbstractScheduledExecutionService.this.execute();
            }
        }, executionPeriod, executionPeriod, timeUnit);
        this.started.set(true);
    }

    public final boolean isStarted() {
        return this.started.get();
    }

    protected abstract void execute();

    protected final void checkStarted() {
        if (!this.started.get()) {
            throw new IllegalStateException("Scheduled Execution Service is not started");
        }
    }

    public final void shutdown() {
        if (this.scheduledExecutionService != null) {
            this.scheduledExecutionService.shutdown();
        }
        this.started.set(false);
    }
}

