/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl;

import com.sap.core.connectivity.tunnel.api.management.TunnelIdService;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdModel;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdParser;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class TunnelIdServiceImpl
implements TunnelIdService {
    private static Logger log = Logger.getLogger(TunnelIdServiceImpl.class);
    private final TunnelIdParser idParser = new TunnelIdParser();

    public String createId(String scheme, String path) {
        this.validateNotEmpty(scheme);
        this.validateNotEmpty(path);
        return this.createTunnelId(scheme, path);
    }

    public String createIdForAccount(String account) {
        this.validateNotEmpty(account);
        TunnelIdModel idModel = new TunnelIdModel();
        idModel.setAccount(account);
        return this.buildTunnelId(idModel);
    }

    public String createIdForAccount(String account, String sccLocationId) {
        this.validateNotEmpty(account);
        TunnelIdModel idModel = new TunnelIdModel();
        idModel.setAccount(account);
        idModel.setLocation(sccLocationId);
        return this.buildTunnelId(idModel);
    }

    public String getAccount(String tunnelId) {
        TunnelIdModel tunnelIdModel = this.parseToModel(tunnelId);
        return tunnelIdModel.getAccount();
    }

    public String getSccLocationId(String tunnelId) {
        TunnelIdModel tunnelIdModel = this.parseToModel(tunnelId);
        return tunnelIdModel.getLocation();
    }

    private TunnelIdModel parseToModel(String tunnelId) {
        try {
            TunnelIdModel tunnelIdModel = this.idParser.parse(tunnelId);
            return tunnelIdModel;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Tunnel identifier is not an URI", e);
        }
    }

    private String buildTunnelId(TunnelIdModel idModel) {
        String path = this.buildPath(idModel);
        if (this.isEmpty(idModel.getScheme())) {
            idModel.setScheme("account");
        }
        return this.createTunnelId(idModel.getScheme(), path);
    }

    private String createTunnelId(String scheme, String path) {
        try {
            String tunnelId = new URI(scheme, "", this.normalizePath(path), null, null).toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created tunnel ID: " + tunnelId));
            }
            return tunnelId;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create tunnel identifier", e);
        }
    }

    private String buildPath(TunnelIdModel idModel) {
        String path = this.normalizePath(idModel.getAccount());
        if (!this.isEmpty(idModel.getLocation())) {
            path = path + this.normalizePath(idModel.getLocation());
        }
        return path;
    }

    private String normalizePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private void validateNotEmpty(String value) {
        if (this.isEmpty(value)) {
            throw new IllegalArgumentException("Argument cannot be empty");
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

