/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ErrorHandler;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ErrorHandlerRegistry {
    private static Logger log = Logger.getLogger(ErrorHandlerRegistry.class);
    private final DefaultErrorHandler defaultHandler = new DefaultErrorHandler();
    private Map<ConnectionProtocol, ErrorHandler> errorHandlers = new ConcurrentHashMap<ConnectionProtocol, ErrorHandler>();

    public ErrorHandler getErrorHandler(ConnectionProtocol protocol) {
        if (protocol == null) {
            return this.defaultHandler;
        }
        if (this.errorHandlers.containsKey(protocol)) {
            return this.errorHandlers.get(protocol);
        }
        log.error((Object)("There is no error handler registered for protocol: " + protocol + ". The default handler will be used."));
        return this.defaultHandler;
    }

    public void registerErrorHandler(ConnectionProtocol protocol, ErrorHandler errorHandler) {
        if (protocol == null) {
            throw new IllegalArgumentException("The connection protocol should not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering error handler for protocol " + protocol));
        }
        this.errorHandlers.put(protocol, errorHandler);
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        public void handleError(Channel channel, int code, String message) {
            log.error((Object)("Channel with id " + ChannelUtil.formatConnectionId((int)ConnectionId.get(channel)) + " will be closed. Error [" + code + "]: " + message));
            ChannelUtil.close((Channel)channel);
        }
    }
}

