/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ErrorHandler;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.extension.ExtensionProvider;
import com.sap.core.connectivity.spi.extension.ExtensionRegistry;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessor;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessorFactory;
import com.sap.core.connectivity.spi.processing.TargetHost;
import com.sap.core.connectivity.tunnel.core.impl.context.ErrorHandlerRegistry;
import com.sap.core.connectivity.tunnel.core.impl.context.OutboundProtocolProcessorRegistry;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ExtensionRegistryImpl
implements ExtensionRegistry {
    private final ErrorHandlerRegistry errorHandlerRegistry = new ErrorHandlerRegistry();
    private final OutboundProtocolProcessorRegistry outboundProtocolProcessorRegistry = new OutboundProtocolProcessorRegistry();

    public ExtensionRegistryImpl() {
        this.loadExtensions();
    }

    public void registerOutboundProtocolProcessorFactory(TargetHost host, OutboundProtocolProcessorFactory factory) {
        this.outboundProtocolProcessorRegistry.registerFactory(host, factory);
    }

    public void unregisterOutboundProtocolProcessorFactory(TargetHost host) {
        this.outboundProtocolProcessorRegistry.unregisterFactory(host);
    }

    public void registerDefaultOutboundProtocolProcessorFactory(ConnectionProtocol connectionProtocol, OutboundProtocolProcessorFactory factory) {
        this.outboundProtocolProcessorRegistry.registerDefaultFactory(connectionProtocol, factory);
    }

    public void unregisterDefaultOutboundProtocolProcessorFactory(ConnectionProtocol connectionProtocol) {
        this.outboundProtocolProcessorRegistry.unregisterDefaultFactory(connectionProtocol);
    }

    public void registerErrorHandler(ConnectionProtocol connectionProtocol, ErrorHandler errorHandler) {
        this.errorHandlerRegistry.registerErrorHandler(connectionProtocol, errorHandler);
    }

    public OutboundProtocolProcessor getOutboundProtocolProcessor(TargetHost host, ProcessingContext processingContext) {
        return this.outboundProtocolProcessorRegistry.getOutboundProtocolProcessor(host, processingContext);
    }

    public ErrorHandler getErrorHandler(ConnectionProtocol protocol) {
        return this.errorHandlerRegistry.getErrorHandler(protocol);
    }

    private void loadExtensions() {
        ServiceLoader<ExtensionProvider> loader = ServiceLoader.load(ExtensionProvider.class);
        Iterator<ExtensionProvider> iterator = loader.iterator();
        while (iterator.hasNext()) {
            iterator.next().register((ExtensionRegistry)this);
        }
    }
}

