/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.NoTunnelsSubscribedException;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.TunnelConnection;
import com.sap.core.connectivity.tunnel.core.connection.ClientConnection;
import com.sap.core.connectivity.tunnel.core.context.InboundConnection;
import com.sap.core.connectivity.tunnel.core.context.InboundConnectionRegistry;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelChannelUnregisteredEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryListenerAdapter;
import com.sap.core.connectivity.tunnel.core.util.ConnectionId;
import io.netty.channel.Channel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class InboundConnectionRegistryImpl
implements InboundConnectionRegistry {
    private static final Logger log = Logger.getLogger(InboundConnectionRegistryImpl.class);
    private final TunnelRegistry tunnelRegistry;
    private final ConcurrentHashMap<Integer, InboundConnection> inboundConnectionMap = new ConcurrentHashMap();

    public InboundConnectionRegistryImpl(TunnelRegistry tunnelRegistry) {
        this.tunnelRegistry = tunnelRegistry;
        this.tunnelRegistry.addListener(new TunnelChannelUnregisteredInboundListener());
    }

    @Override
    public void registerInboundConnection(String tunnelId, Channel inboundChannel, ConnectionProtocol connectionProtocol) {
        Integer inboundConnectionId = ConnectionId.get(inboundChannel);
        ConnectionInformation added = new ConnectionInformation(tunnelId, inboundChannel, connectionProtocol);
        this.inboundConnectionMap.put(inboundConnectionId, added);
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Registered channel: {0}", added.toString()));
        }
    }

    @Override
    public int registerInboundConnection(Set<String> tunnelIds, Channel inboundChannel, ConnectionProtocol connectionProtocol) throws NoTunnelsSubscribedException {
        Integer connectionId = ConnectionId.get(inboundChannel);
        HashSet<TunnelConnection> tunnelConnections = new HashSet<TunnelConnection>(tunnelIds.size());
        for (String tunnelId : tunnelIds) {
            try {
                Tunnel tunnel = this.tunnelRegistry.getTunnel(tunnelId);
                tunnelConnections.add(new TunnelConnection(connectionId, tunnel));
            }
            catch (NoChannelsAvailableException ex) {
                log.info((Object)MessageFormat.format("Tunnel with tunnelId {0} was closed in meantime", tunnelId));
            }
        }
        if (tunnelConnections.isEmpty()) {
            throw new NoTunnelsSubscribedException();
        }
        ClientConnection clientConnection = new ClientConnection(inboundChannel, connectionProtocol, tunnelConnections);
        clientConnection.open();
        this.inboundConnectionMap.put(connectionId, clientConnection);
        return connectionId;
    }

    @Override
    public void unregisterInboundConnection(Channel inboundChannel) {
        Integer inboundConnectionId = ConnectionId.get(inboundChannel);
        InboundConnection inboundConnection = this.inboundConnectionMap.remove(inboundConnectionId);
        boolean traceEnabled = log.isTraceEnabled();
        if (inboundConnection == null) {
            if (traceEnabled) {
                log.trace((Object)MessageFormat.format("Could not unregister channel {0}. Not registered?! E.g. TCP check performed.", inboundChannel));
            }
            return;
        }
        if (inboundConnection instanceof ClientConnection) {
            ((ClientConnection)inboundConnection).close();
        }
        if (traceEnabled) {
            log.trace((Object)MessageFormat.format("Unregistered channel: {0}", inboundConnection.toString()));
        }
    }

    @Override
    public InboundConnection getConnection(int inboundConnectionId) {
        return this.inboundConnectionMap.get(inboundConnectionId);
    }

    @Override
    public Tunnel getTunnel(int connectionId) throws NoChannelsAvailableException {
        ConnectionInformation connectionInformation = (ConnectionInformation)this.inboundConnectionMap.get(connectionId);
        if (connectionInformation == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("There is no connection information for connection with id: {0}", ChannelUtil.formatConnectionId((int)connectionId)));
            }
            return null;
        }
        return this.tunnelRegistry.getTunnel(connectionInformation.getTunnelId());
    }

    public List<InboundConnection> getInboundConnections() {
        return Collections.unmodifiableList(new ArrayList<InboundConnection>(this.inboundConnectionMap.values()));
    }

    class TunnelChannelUnregisteredInboundListener
    extends TunnelRegistryListenerAdapter {
        TunnelChannelUnregisteredInboundListener() {
        }

        @Override
        public void tunnelChannelUnregistered(TunnelChannelUnregisteredEvent event) {
            for (Integer connectionId : event.getClosedConnections()) {
                InboundConnection inboundConnection = (InboundConnection)InboundConnectionRegistryImpl.this.inboundConnectionMap.remove(connectionId);
                if (inboundConnection == null) continue;
                ChannelUtil.close((Channel)inboundConnection.channel());
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)MessageFormat.format("Closed channel {0}", inboundConnection.channel()));
            }
        }
    }

    private static class ConnectionInformation
    implements InboundConnection {
        private final String tunnelId;
        private final Channel channel;
        private ConnectionProtocol protocol = null;

        public ConnectionInformation(String tunnelId, Channel channel, ConnectionProtocol protocol) {
            this.tunnelId = tunnelId;
            this.channel = channel;
            this.protocol = protocol;
        }

        public String getTunnelId() {
            return this.tunnelId;
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public ConnectionProtocol getProtocol() {
            return this.protocol;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("ConnectionInformation [");
            sb.append(String.format(" tunnelId [%s]", this.tunnelId));
            sb.append(String.format("; channel [%s]", this.channel));
            sb.append(String.format("; protocol [%s]", this.protocol));
            sb.append(" ]");
            return sb.toString();
        }
    }
}

