/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.ConnectionProtocol;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessor;
import com.sap.core.connectivity.spi.processing.OutboundProtocolProcessorFactory;
import com.sap.core.connectivity.spi.processing.TargetHost;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

class OutboundProtocolProcessorRegistry {
    private Logger log = Logger.getLogger(this.getClass());
    private Map<TargetHost, OutboundProtocolProcessorFactory> outboundProtocolProcessorFactories = new ConcurrentHashMap<TargetHost, OutboundProtocolProcessorFactory>();
    private Map<ConnectionProtocol, OutboundProtocolProcessorFactory> defaultOutboundProtocolProcessorFactories = new ConcurrentHashMap<ConnectionProtocol, OutboundProtocolProcessorFactory>();

    OutboundProtocolProcessorRegistry() {
    }

    public void registerFactory(TargetHost host, OutboundProtocolProcessorFactory factory) {
        if (this.outboundProtocolProcessorFactories.containsKey(host)) {
            throw new IllegalArgumentException("Factory for host " + host + " already registered");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering outbound processor factory for host " + host));
        }
        this.outboundProtocolProcessorFactories.put(host, factory);
    }

    public void unregisterFactory(TargetHost host) {
        this.outboundProtocolProcessorFactories.remove(host);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed outbound processor factory for host " + host));
        }
    }

    public void registerDefaultFactory(ConnectionProtocol protocol, OutboundProtocolProcessorFactory factory) {
        if (this.defaultOutboundProtocolProcessorFactories.containsKey(protocol)) {
            throw new IllegalArgumentException("Factory for protocol " + protocol + " already registered");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering outbound processor factory for protocol " + protocol));
        }
        this.defaultOutboundProtocolProcessorFactories.put(protocol, factory);
    }

    public void unregisterDefaultFactory(ConnectionProtocol protocol) {
        this.defaultOutboundProtocolProcessorFactories.remove(protocol);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed default outbound processor factory for protocol  " + protocol.toString()));
        }
    }

    public OutboundProtocolProcessor getOutboundProtocolProcessor(TargetHost host, ProcessingContext processingContext) {
        OutboundProtocolProcessorFactory factory = this.outboundProtocolProcessorFactories.get(host);
        if (factory == null) {
            factory = this.getDefaultFactory(host.getProtocol());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Acquiring outbound connection processor for protocol " + host.getProtocol()));
        }
        return factory.getProcessor(host.getProtocol(), processingContext);
    }

    private OutboundProtocolProcessorFactory getDefaultFactory(ConnectionProtocol protocol) {
        OutboundProtocolProcessorFactory factory = this.defaultOutboundProtocolProcessorFactories.get(protocol);
        if (factory == null) {
            throw new IllegalArgumentException("Default factory for protocol " + protocol + " not registered");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Will use default factory for protocol " + protocol));
        }
        return factory;
    }
}

