/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.Tunnel;
import com.sap.core.connectivity.spi.protocol.MessagePacketFactory;
import com.sap.core.connectivity.spi.statistics.PerformanceStatistics;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.mapping.MappingResolver;
import com.sap.core.connectivity.tunnel.api.mapping.MappingResolverProvider;
import com.sap.core.connectivity.tunnel.api.mapping.UnknownTunnelIdException;
import com.sap.core.connectivity.tunnel.core.impl.context.EmptyMappingResolver;
import org.apache.log4j.Logger;

public class ProcessingContextImpl
implements ProcessingContext {
    private static final Logger log = Logger.getLogger(ProcessingContextImpl.class);
    private final Tunnel tunnel;
    private final MessagePacketFactory messagePacketFactory;
    private final ServiceRegistry serviceRegistry;

    public ProcessingContextImpl(Tunnel tunnel, MessagePacketFactory messagePacketFactory, ServiceRegistry serviceRegistry) {
        this.tunnel = tunnel;
        this.messagePacketFactory = messagePacketFactory;
        this.serviceRegistry = serviceRegistry;
    }

    public Tunnel getTunnel() {
        return this.tunnel;
    }

    public MappingResolver getMappingResolver() {
        try {
            MappingResolverProvider mappingResolverProvider = (MappingResolverProvider)this.serviceRegistry.getService(MappingResolverProvider.class);
            return mappingResolverProvider.getResolver(this.tunnel.getId());
        }
        catch (UnknownTunnelIdException e) {
            log.error((Object)String.format("Unable to get mapping resolver for tunnel %s, will return an empty resolver: %s", new Object[]{this.tunnel.getId(), e}));
            return new EmptyMappingResolver();
        }
    }

    public MessagePacketFactory getMessagePacketFactory() {
        return this.messagePacketFactory;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public PerformanceStatistics getPerformanceStatistics(int connectionId) {
        return PerformanceStatistics.getStatistics((int)connectionId);
    }
}

