/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.tunnel.api.LookupException;
import com.sap.core.connectivity.tunnel.api.ServiceRegistry;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableService;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private Map<Class<?>, TunnelConsumableService> registeredServices = new ConcurrentHashMap();

    public synchronized <T extends TunnelConsumableService> T getService(Class<T> serviceClass) {
        TunnelConsumableService registeredService = this.registeredServices.get(serviceClass);
        if (registeredService != null) {
            if (!TunnelConsumableService.class.isAssignableFrom(registeredService.getClass())) {
                throw new IllegalStateException(String.format("Expected <%s> but was <%s>", TunnelConsumableService.class.getName(), registeredService.getClass().getName()));
            }
            return (T)registeredService;
        }
        return (T)TunnelConsumableServices.getService(serviceClass);
    }

    public <T extends TunnelConsumableService> T getOptionalService(Class<T> serviceClass) {
        try {
            return this.getService(serviceClass);
        }
        catch (LookupException e) {
            return null;
        }
    }

    public <T extends TunnelConsumableService> void registerService(Class<T> serviceClass, T service) {
        this.registeredServices.put(serviceClass, service);
    }

    public void unregisterAllServices() {
        this.registeredServices.clear();
    }
}

