/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;

public class TunnelBridge
implements com.sap.core.connectivity.spi.Tunnel {
    private final String id;
    private final TunnelRegistry tunnelRegistry;

    public TunnelBridge(String id, TunnelRegistry tunnelRegistry) {
        this.id = id;
        this.tunnelRegistry = tunnelRegistry;
    }

    public String getId() {
        return this.id;
    }

    public Channel getChannel(int connectionId) throws NoChannelsAvailableException {
        Tunnel tunnel = this.tunnelRegistry.getTunnel(this.id);
        Channel channel = tunnel.getSubscribedChannel(connectionId);
        if (channel == null) {
            throw new NoChannelsAvailableException();
        }
        return channel;
    }

    public ChannelFuture write(MessagePacket messagePacket) throws NoChannelsAvailableException {
        if (messagePacket.getConnectionId() == 0) {
            throw new IllegalArgumentException("Package must be with connection identifier");
        }
        Tunnel tunnel = this.tunnelRegistry.getTunnel(this.id);
        ChannelFuture channelFuture = tunnel.writeToSubscribedChannel(messagePacket.getConnectionId(), messagePacket);
        if (channelFuture == null) {
            throw new NoChannelsAvailableException();
        }
        return channelFuture;
    }
}

