/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.context;

import com.sap.core.connectivity.spi.NoChannelsAvailableException;
import com.sap.core.connectivity.tunnel.core.Tunnel;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistrationException;
import com.sap.core.connectivity.tunnel.core.context.TunnelRegistry;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelChannelRegisteredEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelChannelUnregisteredEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelClosedEvent;
import com.sap.core.connectivity.tunnel.core.impl.context.TunnelRegistryListener;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdModel;
import com.sap.core.connectivity.tunnel.core.util.TunnelIdParser;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class TunnelRegistryImpl
implements TunnelRegistry {
    private static Logger log = Logger.getLogger(TunnelRegistryImpl.class);
    private final TunnelIdParser idParser = new TunnelIdParser();
    private final ConcurrentHashMap<String, Tunnel> tunnelsMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> clientIdsMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<String>> accountToTunnelIdsMap = new ConcurrentHashMap();
    private final List<TunnelRegistryListener> tunnelRegistryListeners = Collections.synchronizedList(new ArrayList());
    private final ConnectivityContext context;

    public TunnelRegistryImpl(ConnectivityContext context) {
        this.context = context;
    }

    @Override
    public void registerTunnelChannel(String tunnelId, String clientId, Channel channel) throws TunnelRegistrationException {
        this.registerTunnelChannel(tunnelId, clientId, channel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTunnelChannel(final String tunnelId, final String clientId, final Channel channel, ChannelFuture channelAvailabilityFuture) throws TunnelRegistrationException {
        ConcurrentHashMap<String, String> concurrentHashMap = this.clientIdsMap;
        synchronized (concurrentHashMap) {
            String currentClientId = this.clientIdsMap.get(tunnelId);
            if (currentClientId != null && !currentClientId.equals(clientId)) {
                throw new TunnelRegistrationException(MessageFormat.format("Unable to register tunnel with id \"{0}\" for client identifier \"{1}\". There are already channels registered for this tunnel id with client identifier \"{2}\"", tunnelId, clientId, currentClientId));
            }
            this.clientIdsMap.putIfAbsent(tunnelId, clientId);
            this.addInAccountToTunnelIdsMap(tunnelId);
            if (channelAvailabilityFuture != null) {
                channelAvailabilityFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            TunnelRegistryImpl.this.makeChannelAvailable(tunnelId, clientId, channel);
                        }
                    }
                });
            } else {
                this.makeChannelAvailable(tunnelId, clientId, channel);
            }
            channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    TunnelRegistryImpl.this.unregisterTunnelChannel(tunnelId, future.channel());
                }
            });
        }
    }

    private void addInAccountToTunnelIdsMap(String tunnelId) {
        try {
            TunnelIdModel idModel = this.idParser.parse(tunnelId);
            String account = idModel.getAccount();
            if (account == null || account.isEmpty()) {
                log.debug((Object)String.format("Account not found in the model parsed from tunnel ID [%s]. Tunnel will not be added to the account to tunnels map!", tunnelId));
                return;
            }
            if (this.accountToTunnelIdsMap.containsKey(account)) {
                Set<String> tunnelIds = this.accountToTunnelIdsMap.get(account);
                tunnelIds.add(tunnelId);
            } else {
                HashSet<String> tunnelIds = new HashSet<String>();
                tunnelIds.add(tunnelId);
                this.accountToTunnelIdsMap.put(account, tunnelIds);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private void removeFromAccountToTunnelIdsMap(String tunnelId) {
        try {
            TunnelIdModel idModel = this.idParser.parse(tunnelId);
            String account = idModel.getAccount();
            if (account == null || account.isEmpty()) {
                log.debug((Object)String.format("Account not found in the model parsed from tunnel ID [%s]. Tunnel will not be added to the account to tunnels map!", tunnelId));
                return;
            }
            if (this.accountToTunnelIdsMap.containsKey(account)) {
                Set<String> accountTunnelIds = this.accountToTunnelIdsMap.get(account);
                accountTunnelIds.remove(tunnelId);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeChannelAvailable(String tunnelId, String clientId, Channel channel) {
        Tunnel tunnel;
        Tunnel tunnel2 = tunnel = this.getOrCreateTunnel(tunnelId, clientId);
        synchronized (tunnel2) {
            if (!tunnel.containsChannel(channel)) {
                tunnel.add(channel);
                this.fireTunnelChannelRegisteredEvent(tunnelId);
                log.info((Object)MessageFormat.format("Registered tunnel channel {0} for tunnel id \"{1}\" and client id \"{2}\"", channel, tunnelId, clientId));
            }
        }
    }

    private Tunnel getOrCreateTunnel(String tunnelId, String clientId) {
        Tunnel currentTunnel;
        Tunnel tunnel = this.tunnelsMap.get(tunnelId);
        if (tunnel == null && (currentTunnel = this.tunnelsMap.putIfAbsent(tunnelId, tunnel = new Tunnel(tunnelId, clientId, this.context))) != null) {
            tunnel.dispose();
            tunnel = currentTunnel;
        }
        return tunnel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTunnelChannel(String tunnelId, Channel channel) {
        ConcurrentHashMap<String, Tunnel> concurrentHashMap = this.tunnelsMap;
        synchronized (concurrentHashMap) {
            Tunnel tunnel = this.tunnelsMap.get(tunnelId);
            if (tunnel != null) {
                List<Integer> removedConnections = tunnel.remove(channel);
                this.fireTunnelChannelUnregisteredEvent(tunnelId, removedConnections, tunnel.getClientId());
                log.info((Object)MessageFormat.format("Unregistered tunnel channel {0} for tunnel id \"{1}\"", channel, tunnelId));
                if (tunnel.getChannelCount() == 0) {
                    this.makeTunnelClosed(tunnelId, tunnel);
                }
            } else {
                this.clientIdsMap.remove(tunnelId);
                this.removeFromAccountToTunnelIdsMap(tunnelId);
            }
        }
    }

    private void makeTunnelClosed(String tunnelId, Tunnel tunnel) {
        String clientId = tunnel.getClientId();
        tunnel.dispose();
        this.tunnelsMap.remove(tunnelId);
        this.clientIdsMap.remove(tunnelId);
        this.removeFromAccountToTunnelIdsMap(tunnelId);
        this.fireTunnelClosedEvent(tunnelId, clientId);
        log.info((Object)MessageFormat.format("Close tunnel with id \"{0}\" and client id \"{1}\"", tunnelId, clientId));
    }

    @Override
    public Tunnel getTunnel(String tunnelId) throws NoChannelsAvailableException {
        Tunnel tunnel = this.tunnelsMap.get(tunnelId);
        if (tunnel != null && tunnel.getChannelCount() > 0) {
            return tunnel;
        }
        NoChannelsAvailableException noChannelsAvailableException = new NoChannelsAvailableException();
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Tunnel either not registered or no tunnel channels are available: Tunnel: {0}; Tunnel channel count: {1}; Tunnel ID: {2}, Throwing exception:", tunnel, tunnel != null ? tunnel.getChannelCount() : 0, tunnelId), (Throwable)noChannelsAvailableException);
        }
        throw noChannelsAvailableException;
    }

    @Override
    public Collection<Tunnel> getTunnels() {
        return Collections.unmodifiableCollection(this.tunnelsMap.values());
    }

    @Override
    public Collection<String> getTunnelIds(String account) {
        return this.accountToTunnelIdsMap.get(account);
    }

    @Override
    public boolean hasTunnel(String tunnelId) {
        Tunnel tunnel = this.tunnelsMap.get(tunnelId);
        return tunnel != null && tunnel.getChannelCount() > 0;
    }

    @Override
    public void closeTunnel(String tunnelId) {
        Tunnel tunnel = this.tunnelsMap.get(tunnelId);
        if (tunnel != null) {
            tunnel.closeAllChannels();
        }
    }

    @Override
    public void addListener(TunnelRegistryListener listener) {
        this.tunnelRegistryListeners.add(listener);
    }

    @Override
    public void removeListener(TunnelRegistryListener listener) {
        this.tunnelRegistryListeners.remove(listener);
    }

    private void fireTunnelChannelRegisteredEvent(String tunnelId) {
        for (TunnelRegistryListener listener : this.tunnelRegistryListeners) {
            TunnelChannelRegisteredEvent event = new TunnelChannelRegisteredEvent(tunnelId);
            try {
                listener.tunnelChannelRegistered(event);
            }
            catch (Exception e) {
                log.error((Object)"Firing tunnel channel registered event threw an exception", (Throwable)e);
            }
        }
    }

    private void fireTunnelChannelUnregisteredEvent(String tunnelId, List<Integer> removedConnections, String clientId) {
        for (TunnelRegistryListener listener : this.tunnelRegistryListeners) {
            TunnelChannelUnregisteredEvent event = new TunnelChannelUnregisteredEvent(tunnelId, removedConnections, clientId);
            try {
                listener.tunnelChannelUnregistered(event);
            }
            catch (Exception e) {
                log.error((Object)"Firing tunnel channel unregistered event threw an exception", (Throwable)e);
            }
        }
    }

    private void fireTunnelClosedEvent(String tunnelId, String clientId) {
        for (TunnelRegistryListener listener : this.tunnelRegistryListeners) {
            TunnelClosedEvent event = new TunnelClosedEvent(tunnelId, clientId);
            try {
                listener.tunnelClosed(event);
            }
            catch (Exception e) {
                log.error((Object)"Firing tunnel closed event threw an exception", (Throwable)e);
            }
        }
    }
}

