/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.tunnel.core.impl.processing;

import com.sap.core.connectivity.spi.ErrorHandler;
import com.sap.core.connectivity.spi.ProcessingContext;
import com.sap.core.connectivity.spi.TunnelException;
import com.sap.core.connectivity.spi.extension.ExtensionRegistry;
import com.sap.core.connectivity.spi.processing.flow.DemandReadEvent;
import com.sap.core.connectivity.spi.protocol.MessagePacket;
import com.sap.core.connectivity.spi.protocol.PayloadMessagePacket;
import com.sap.core.connectivity.spi.util.ChannelUtil;
import com.sap.core.connectivity.tunnel.api.TunnelProvidedServices;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.core.context.ConnectivityContext;
import com.sap.core.connectivity.tunnel.core.context.InboundConnection;
import com.sap.core.connectivity.tunnel.core.context.MessagePacketProcessor;
import com.sap.core.connectivity.tunnel.core.impl.processing.OpenBackendConnectionSucceededEvent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class InboundPacketProcessor
implements MessagePacketProcessor {
    private static final Logger log = Logger.getLogger(InboundPacketProcessor.class);
    private final ConnectivityContext connectivityContext;
    private final ExtensionRegistry extensionRegistry;

    public InboundPacketProcessor(ConnectivityContext connectivityContext) {
        this.connectivityContext = connectivityContext;
        this.extensionRegistry = (ExtensionRegistry)TunnelProvidedServices.getService(ExtensionRegistry.class);
    }

    @Override
    public boolean acceptsPacket(MessagePacket packet) {
        if (!"system".equals(packet.getOwner())) {
            return false;
        }
        return this.connectivityContext.getInboundConnectionRegistry().getConnection(packet.getConnectionId()) != null;
    }

    @Override
    public boolean processPacket(MessagePacket packet, Channel tunnelChannel, ProcessingContext processingContext) {
        InboundConnection connection = this.connectivityContext.getInboundConnectionRegistry().getConnection(packet.getConnectionId());
        if (connection == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("There is no inbound connection registered for this id %s", packet.getConnectionId()));
            }
            return false;
        }
        Channel clientConnectionChannel = connection.channel();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Client channel: " + ChannelUtil.getChannelStateDetails((Channel)clientConnectionChannel) + " Tunnel channel autoread: " + tunnelChannel.config().isAutoRead()));
        }
        try {
            switch (packet.getType()) {
                case 3: {
                    this.writePayload((PayloadMessagePacket)packet, connection, tunnelChannel);
                    break;
                }
                case 4: {
                    this.writeError(packet, connection, tunnelChannel);
                    break;
                }
                case 5: {
                    this.notifyBackendConnectionOpened(packet, connection);
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, connection);
        }
        return false;
    }

    private void notifyBackendConnectionOpened(MessagePacket packet, InboundConnection connection) {
        String virtualHost = packet.getProperty("host");
        String virtualPort = packet.getProperty("port");
        connection.channel().pipeline().fireUserEventTriggered((Object)new OpenBackendConnectionSucceededEvent(virtualHost, virtualPort));
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("Fired open inbound connection succeeded event for virtual host:port -> {0}:{1}", virtualHost, virtualPort));
        }
    }

    private void writePayload(final PayloadMessagePacket packet, InboundConnection connection, final Channel tunnelChannel) {
        TunnelConfiguration tunnelConfiguration = (TunnelConfiguration)this.connectivityContext.getServiceRegistry().getService(TunnelConfiguration.class);
        final boolean isMemorySafeMode = tunnelConfiguration.getServerMemorySafeMode();
        final long clientWriteWarningThresholdMillis = tunnelConfiguration.getServerTunnelWriteWarningThresholdMillis();
        final Channel clientChannel = connection.channel();
        if (!clientChannel.isOpen() || !clientChannel.isActive()) {
            this.logDiscardingPacketFromTunnelChannel((MessagePacket)packet, tunnelChannel, clientChannel);
            return;
        }
        ReferenceCountUtil.retain((Object)packet);
        final ByteBuf payload = packet.getPayload();
        final boolean traceEnabled = log.isTraceEnabled();
        if (traceEnabled) {
            log.trace((Object)MessageFormat.format("Will send message of type {0} with payload size {1} to client channel {2}", packet.getType(), payload.writerIndex(), clientChannel));
        }
        ChannelFuture clientWriteFuture = clientChannel.writeAndFlush((Object)payload);
        final ChannelConfig tunnelChannelConfig = tunnelChannel.config();
        clientWriteFuture.addListener((GenericFutureListener)new ChannelFutureListener(){
            private final long startTimeMillis = System.currentTimeMillis();
            private final boolean stopReadingFromTunnel;
            {
                boolean bl3 = this.stopReadingFromTunnel = isMemorySafeMode && !clientChannel.isWritable() && tunnelChannelConfig.isAutoRead();
                if (this.stopReadingFromTunnel) {
                    tunnelChannelConfig.setAutoRead(false);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)MessageFormat.format("Set autoread=FALSE on Tunnel channel: {0}; Client channel: {1} {2}", tunnelChannel, clientChannel, ChannelUtil.getChannelStateDetails((Channel)clientChannel)));
                    }
                }
            }

            public void operationComplete(ChannelFuture future) {
                Channel channel = future.channel();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Client channel write future completed. Client channel: " + ChannelUtil.getChannelStateDetails((Channel)channel)));
                }
                if (this.stopReadingFromTunnel) {
                    DemandReadEvent demandReadEvent = DemandReadEvent.INSTANCE;
                    tunnelChannelConfig.setAutoRead(true);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)MessageFormat.format("Set autoread=TRUE on Tunnel channel: {0}; Client channel: {1}; Trigger event {2}", tunnelChannel, channel, demandReadEvent.getClass().getSimpleName()));
                    }
                    tunnelChannel.pipeline().fireUserEventTriggered((Object)demandReadEvent);
                }
                int payloadPacketSize = payload.writerIndex();
                if (future.isSuccess()) {
                    long clientWriteTimeMillis;
                    if (traceEnabled) {
                        log.trace((Object)MessageFormat.format("Sent message of type {0} with payload size {1} to client channel {2}", packet.getType(), payloadPacketSize, channel));
                    }
                    if ((clientWriteTimeMillis = System.currentTimeMillis() - this.startTimeMillis) > clientWriteWarningThresholdMillis) {
                        log.warn((Object)MessageFormat.format("Threshold of {0} passed. Packet with size {1} sent for {2} milliseconds to client channel {3}. Tunnel id: {4}", clientWriteWarningThresholdMillis, payloadPacketSize, clientWriteTimeMillis, channel));
                    }
                } else {
                    Object cause = future.cause() != null ? future.cause() : "not available";
                    String failureReason = "FAILED";
                    if (future.isCancelled()) {
                        failureReason = "CANCELED";
                    }
                    log.error((Object)MessageFormat.format("Write operation {0} for payload message packet with size {1} for client channel {2}. Cause: {3}", failureReason, payloadPacketSize, channel, cause));
                }
            }
        });
    }

    private void writeError(MessagePacket packet, InboundConnection connection, Channel tunnelChannel) {
        String message;
        int code;
        Channel clientChannel = connection.channel();
        if (!clientChannel.isOpen() || !clientChannel.isActive()) {
            this.logDiscardingPacketFromTunnelChannel(packet, tunnelChannel, clientChannel);
            return;
        }
        ErrorHandler errorHandler = this.extensionRegistry.getErrorHandler(connection.getProtocol());
        if (packet.getType() == 4) {
            String messageErrorCode = packet.getProperty("errorCode");
            code = messageErrorCode != null && !messageErrorCode.isEmpty() ? Integer.parseInt(messageErrorCode) : 0;
            String messageString = packet.getProperty("errorMessage");
            message = messageString != null && !messageString.isEmpty() ? messageString : this.generateUnknownMessageDetails(packet);
        } else {
            code = 0;
            message = this.generateUnknownMessageDetails(packet);
            log.error((Object)MessageFormat.format("Expected message packet of type {0} but was {1}", 4, message));
        }
        errorHandler.handleError(clientChannel, code, message);
    }

    private void handleException(Exception cause, InboundConnection connection) {
        log.error((Object)"Internal error", (Throwable)cause);
        Channel channel = connection.channel();
        if (channel.isOpen()) {
            int errorCode = cause instanceof TunnelException ? ((TunnelException)cause).getErrorCode() : 100;
            String message = cause != null && cause.getMessage() != null ? cause.getMessage() : "Internal processing error";
            ErrorHandler errorHandler = this.extensionRegistry.getErrorHandler(connection.getProtocol());
            errorHandler.handleError(channel, errorCode, message);
        }
    }

    private String generateUnknownMessageDetails(MessagePacket packet) {
        return MessageFormat.format("Unknown error message! Message Packet Type: {0}; Owner: {1}; Connection ID: {2}", packet.getType(), packet.getOwner(), packet.getConnectionId());
    }

    private void logDiscardingPacketFromTunnelChannel(MessagePacket packet, Channel tunnelChannel, Channel clientChannel) {
        if (log.isTraceEnabled()) {
            boolean isPayload = packet instanceof PayloadMessagePacket;
            if (isPayload) {
                PayloadMessagePacket payloadPacket = (PayloadMessagePacket)packet;
                log.trace((Object)MessageFormat.format("Discarding message of type {0} with size {1} over tunnel channel {2}. Cannot write to client channel {3}", payloadPacket.getType(), payloadPacket.getPayload().writerIndex(), tunnelChannel, ChannelUtil.getChannelStateDetails((Channel)clientChannel)));
            } else {
                log.trace((Object)MessageFormat.format("Discarding message of type {0} over tunnel channel {1}. Cannot write to client channel {2}", packet.getType(), tunnelChannel, ChannelUtil.getChannelStateDetails((Channel)clientChannel)));
            }
        }
    }
}

